/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa;

import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import java.util.Locale;

class SaJdwpUtils {
    SaJdwpUtils() {
    }

    static VirtualMachineImpl createVirtualMachine(String target) throws Exception {
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        try {
            return VirtualMachineImpl.createVirtualMachineForPID(virtualMachineManager, Integer.parseInt(target), 0);
        }
        catch (NumberFormatException e) {
            String javaExeName = System.getProperty("java.home") + "\\bin\\java";
            if (SaJdwpUtils.isWindows()) {
                javaExeName = javaExeName + ".exe";
            }
            return VirtualMachineImpl.createVirtualMachineForCorefile(virtualMachineManager, javaExeName, target, 0);
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
    }
}

