/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.threadingModelHelper;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.devkit.threadingModelHelper.TMHInstrumenter;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class TMHInstrumentingBuilder
extends BaseInstrumentingBuilder {
    private static final Logger LOG = Logger.getInstance(TMHInstrumentingBuilder.class);
    private static final String INSTRUMENT_ANNOTATIONS_PROPERTY = "tmh.instrument.annotations";

    @NotNull
    public String getPresentableName() {
        return "Threading Model annotations instrumentation";
    }

    protected String getProgressMessage() {
        return "Adding Threading Model assertions...";
    }

    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        return SystemProperties.getBooleanProperty((String)INSTRUMENT_ANNOTATIONS_PROPERTY, (boolean)false);
    }

    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return !"module-info".equals(compiledClass.getClassName());
    }

    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiledClass, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        try {
            if (TMHInstrumenter.instrument(reader, (ClassVisitor)writer)) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            Collection sourceFiles = compiledClass.getSourceFiles();
            String msg = "Cannot instrument " + ContainerUtil.map((Collection)sourceFiles, File::getName) + ": " + e.getMessage();
            String firstFile = (String)ContainerUtil.getFirstItem((List)compiledClass.getSourceFilesPaths());
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, msg, firstFile));
        }
        return null;
    }
}

