/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.impl.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.ArtifactType;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.ArtifactTypeRegistry;

class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session) {
        return CachingArtifactTypeRegistry.newInstance(session.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate) {
        return delegate != null ? new CachingArtifactTypeRegistry(delegate) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate) {
        this.delegate = delegate;
        this.types = new HashMap<String, ArtifactType>();
    }

    public ArtifactType get(String typeId) {
        ArtifactType type = this.types.get(typeId);
        if (type == null) {
            type = this.delegate.get(typeId);
            this.types.put(typeId, type);
        }
        return type;
    }
}

