/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.transport.connect;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.gradle.internal.impldep.org.simpleframework.transport.Server;
import org.gradle.internal.impldep.org.simpleframework.transport.connect.Acceptor;
import org.gradle.internal.impldep.org.simpleframework.transport.connect.ConnectionException;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.DirectReactor;
import org.gradle.internal.impldep.org.simpleframework.transport.reactor.Reactor;

class Listener
implements Closeable {
    private final Acceptor acceptor;
    private final Reactor reactor;

    public Listener(SocketAddress address, Server processor) throws IOException {
        this(address, null, processor);
    }

    public Listener(SocketAddress address, SSLContext context, Server processor) throws IOException {
        this.acceptor = new Acceptor(address, context, processor);
        this.reactor = new DirectReactor();
        this.process();
    }

    public SocketAddress getAddress() {
        return this.acceptor.getAddress();
    }

    private void process() throws IOException {
        try {
            this.reactor.process(this.acceptor, 16);
        }
        catch (Exception e) {
            throw new ConnectionException("Listen error", e);
        }
    }

    public void close() throws IOException {
        try {
            this.acceptor.close();
            this.reactor.stop();
        }
        catch (Exception e) {
            throw new ConnectionException("Close error", e);
        }
    }
}

