/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.simpleframework.http.ContentType;
import org.gradle.internal.impldep.org.simpleframework.http.Form;
import org.gradle.internal.impldep.org.simpleframework.http.Part;
import org.gradle.internal.impldep.org.simpleframework.http.Request;
import org.gradle.internal.impldep.org.simpleframework.http.core.Body;
import org.gradle.internal.impldep.org.simpleframework.http.core.Channel;
import org.gradle.internal.impldep.org.simpleframework.http.core.Entity;
import org.gradle.internal.impldep.org.simpleframework.http.core.FormCreator;
import org.gradle.internal.impldep.org.simpleframework.http.core.Monitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.RequestMessage;
import org.gradle.internal.impldep.org.simpleframework.http.session.Session;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseException;

class RequestEntity
extends RequestMessage
implements Request {
    private FormCreator builder;
    private Channel channel;
    private Entity entity;
    private Body body;
    private Map map;
    private Form form;

    public RequestEntity(Entity entity, Monitor monitor) {
        this.builder = new FormCreator(this, entity);
        this.channel = entity.getChannel();
        this.header = entity.getHeader();
        this.body = entity.getBody();
        this.entity = entity;
    }

    public boolean isSecure() {
        return this.channel.isSecure();
    }

    public boolean isKeepAlive() {
        if (this.contains("Connection")) {
            return !this.contains("Connection", "close");
        }
        if (this.getMajor() > 1) {
            return true;
        }
        if (this.getMajor() == 1) {
            return this.getMinor() > 0;
        }
        return false;
    }

    public InetSocketAddress getClientAddress() {
        SocketChannel socket = this.channel.getSocket();
        Socket client = socket.socket();
        return this.getClientAddress(client);
    }

    private InetSocketAddress getClientAddress(Socket socket) {
        InetAddress address = socket.getInetAddress();
        int port = socket.getPort();
        return new InetSocketAddress(address, port);
    }

    public String getContent() throws IOException {
        ContentType type = this.getContentType();
        if (type == null) {
            return this.body.getContent("UTF-8");
        }
        return this.getContent(type);
    }

    public String getContent(ContentType type) throws IOException {
        String charset = type.getCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        return this.body.getContent(charset);
    }

    public InputStream getInputStream() throws IOException {
        return this.body.getInputStream();
    }

    public ReadableByteChannel getByteChannel() throws IOException {
        InputStream source = this.getInputStream();
        if (source != null) {
            return Channels.newChannel(source);
        }
        return null;
    }

    public Session getSession() throws LeaseException {
        return this.getSession(true);
    }

    public Session getSession(boolean create) throws LeaseException {
        return this.entity.getSession(create);
    }

    public Map getAttributes() {
        Map common = this.channel.getAttributes();
        if (this.map == null) {
            this.map = new HashMap(common);
        }
        return this.map;
    }

    public Object getAttribute(Object key) {
        return this.getAttributes().get(key);
    }

    public String getParameter(String name) throws IOException {
        if (this.form == null) {
            this.form = this.builder.getInstance();
        }
        return (String)this.form.get(name);
    }

    public Part getPart(String name) throws IOException {
        if (this.form == null) {
            this.form = this.builder.getInstance();
        }
        return this.form.getPart(name);
    }

    public Form getForm() throws IOException {
        if (this.form == null) {
            this.form = this.builder.getInstance();
        }
        return this.form;
    }
}

