/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.wagon.events;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferEvent;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferListener;

public final class TransferEventSupport {
    private final List<TransferListener> listeners = new ArrayList<TransferListener>();

    public synchronized void addTransferListener(TransferListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeTransferListener(TransferListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized boolean hasTransferListener(TransferListener listener) {
        return this.listeners.contains(listener);
    }

    public synchronized void fireTransferStarted(TransferEvent transferEvent) {
        for (TransferListener listener : this.listeners) {
            listener.transferStarted(transferEvent);
        }
    }

    public synchronized void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        for (TransferListener listener : this.listeners) {
            listener.transferProgress(transferEvent, buffer, length);
        }
    }

    public synchronized void fireTransferCompleted(TransferEvent transferEvent) {
        for (TransferListener listener : this.listeners) {
            listener.transferCompleted(transferEvent);
        }
    }

    public synchronized void fireTransferError(TransferEvent transferEvent) {
        for (TransferListener listener : this.listeners) {
            listener.transferError(transferEvent);
        }
    }

    public synchronized void fireDebug(String message) {
        for (TransferListener listener : this.listeners) {
            listener.debug(message);
        }
    }

    public synchronized void fireTransferInitiated(TransferEvent transferEvent) {
        for (TransferListener listener : this.listeners) {
            listener.transferInitiated(transferEvent);
        }
    }
}

