/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import icons.AntIcons;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private AntBuildTarget mySelectedTarget;
    private Tree myTree;

    public TargetChooserDialog(Project project, AntBuildTarget selectedTarget) {
        super(project, false);
        this.myProject = project;
        this.mySelectedTarget = selectedTarget;
        this.setTitle(AntBundle.message("ant.target.choser.title", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myTree = this.initTree();
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TargetChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (TargetChooserDialog.this.mySelectedTarget != null) {
                    TargetChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ant/config/impl/TargetChooserDialog$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        return JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree));
    }

    private Tree initTree() {
        @NonNls DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        final Tree tree = new Tree((TreeNode)root);
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = tree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    if (userObject instanceof AntTargetNodeDescriptor) {
                        AntTargetNodeDescriptor antBuildTarget = (AntTargetNodeDescriptor)userObject;
                        TargetChooserDialog.this.mySelectedTarget = antBuildTarget.getAntTarget();
                    } else {
                        TargetChooserDialog.this.mySelectedTarget = null;
                    }
                }
            }
        });
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree, path -> {
            @NonNls @NonNls Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (userObject instanceof AntTargetNodeDescriptor) {
                AntBuildTarget target = ((AntTargetNodeDescriptor)userObject).getAntTarget();
                return target.getDisplayName();
            }
            return null;
        });
        DefaultMutableTreeNode selectedNode = null;
        AntConfigurationBase antConfiguration = AntConfigurationImpl.getInstance(this.myProject);
        for (AntBuildFile antBuildFile : antConfiguration.getBuildFileList()) {
            DefaultMutableTreeNode buildFileNode = new DefaultMutableTreeNode(antBuildFile);
            DefaultMutableTreeNode selection = this.processFileTargets(antConfiguration.getMetaTargets(antBuildFile), antBuildFile, buildFileNode);
            if (selection != null) {
                selectedNode = selection;
            }
            if ((selection = this.processFileTargets(antConfiguration.getModel(antBuildFile).getTargets(), antBuildFile, buildFileNode)) != null) {
                selectedNode = selection;
            }
            root.add(buildFileNode);
        }
        TreeUtil.expandAll((JTree)tree);
        TreeUtil.selectInTree(selectedNode, (boolean)true, (JTree)tree);
        return tree;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private DefaultMutableTreeNode processFileTargets(AntBuildTarget[] targets, AntBuildFile buildFile, DefaultMutableTreeNode buildFileNode) {
        DefaultMutableTreeNode result = null;
        for (AntBuildTarget target : targets) {
            if (target.getName() == null) continue;
            AntTargetNodeDescriptor descriptor = new AntTargetNodeDescriptor(target, buildFile);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(descriptor);
            if (this.isSelected(descriptor)) {
                result = node;
            }
            buildFileNode.add(node);
        }
        return result;
    }

    private boolean isSelected(AntTargetNodeDescriptor descriptor) {
        return this.mySelectedTarget != null && Comparing.strEqual((String)this.mySelectedTarget.getName(), (String)descriptor.getAntTarget().getName()) && this.mySelectedTarget.getModel().getBuildFile() == descriptor.getBuildFile();
    }

    @Nullable
    public AntBuildTarget getSelectedTarget() {
        return this.mySelectedTarget;
    }

    private static class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof AntBuildFile) {
                    this.append(((AntBuildFile)userObject).getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else if (userObject instanceof AntTargetNodeDescriptor) {
                    AntTargetNodeDescriptor descriptor = (AntTargetNodeDescriptor)userObject;
                    AntBuildTarget antTarget = descriptor.getAntTarget();
                    String antTargetName = antTarget.getName();
                    this.append(antTargetName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    boolean isMeta = antTarget instanceof MetaTarget;
                    this.setIcon(isMeta ? AntIcons.MetaTarget : AllIcons.Nodes.Target);
                }
            }
        }
    }

    private static class AntTargetNodeDescriptor {
        private final AntBuildTarget myAntTarget;
        private final AntBuildFile myBuildFile;

        AntTargetNodeDescriptor(AntBuildTarget antTarget, AntBuildFile buildFile) {
            this.myAntTarget = antTarget;
            this.myBuildFile = buildFile;
        }

        public AntBuildTarget getAntTarget() {
            return this.myAntTarget;
        }

        public AntBuildFile getBuildFile() {
            return this.myBuildFile;
        }
    }
}

