/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="antWorkspaceConfiguration", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class AntWorkspaceConfiguration
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(AntWorkspaceConfiguration.class);
    private final Project myProject;
    @NonNls
    private static final String BUILD_FILE = "buildFile";
    @NonNls
    private static final String URL = "url";
    private final AtomicReference<Element> myProperties = new AtomicReference<Object>(null);
    public boolean IS_AUTOSCROLL_TO_SOURCE;
    public boolean FILTER_TARGETS;

    public AntWorkspaceConfiguration(Project project) {
        this.myProject = project;
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            AntWorkspaceConfiguration.$$$reportNull$$$0(0);
        }
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
        this.myProperties.set(parentNode);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        for (AntBuildFile antBuildFile : AntConfiguration.getInstance(this.myProject).getBuildFileList()) {
            Element element = new Element(BUILD_FILE);
            element.setAttribute(URL, antBuildFile.getVirtualFile().getUrl());
            ((AntBuildFileBase)antBuildFile).writeWorkspaceProperties(element);
            parentNode.addContent(element);
        }
    }

    public static AntWorkspaceConfiguration getInstance(Project project) {
        return (AntWorkspaceConfiguration)ServiceManager.getService((Project)project, AntWorkspaceConfiguration.class);
    }

    public void loadFileProperties() throws InvalidDataException {
        Element properties = this.myProperties.getAndSet(null);
        if (properties == null) {
            return;
        }
        for (AntBuildFile antBuildFile : AntConfiguration.getInstance(this.myProject).getBuildFileList()) {
            Element fileElement = AntWorkspaceConfiguration.findChildByUrl(properties, antBuildFile.getVirtualFile().getUrl());
            if (fileElement == null) continue;
            ((AntBuildFileBase)antBuildFile).readWorkspaceProperties(fileElement);
        }
    }

    @Nullable
    private static Element findChildByUrl(Element parentNode, String url) {
        for (Element element : parentNode.getChildren(BUILD_FILE)) {
            if (!Objects.equals(element.getAttributeValue(URL), url)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ant/config/impl/AntWorkspaceConfiguration", "loadState"));
    }
}

