/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsComplexPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsModuleOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.module.JpsModule;

public final class JpsArtifactUtil {
    public static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<? super JpsPackagingElement> processor) {
        if (element == null) {
            JpsArtifactUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JpsArtifactUtil.$$$reportNull$$$0(1);
        }
        return JpsArtifactUtil.processPackagingElements(element, processor, new HashSet());
    }

    private static boolean processPackagingElements(@NotNull JpsPackagingElement element, @NotNull Processor<? super JpsPackagingElement> processor, Set<? super JpsPackagingElement> processed) {
        block7: {
            block6: {
                if (element == null) {
                    JpsArtifactUtil.$$$reportNull$$$0(2);
                }
                if (processor == null) {
                    JpsArtifactUtil.$$$reportNull$$$0(3);
                }
                if (!processed.add((JpsPackagingElement)element)) {
                    return false;
                }
                if (!processor.process((Object)element)) {
                    return false;
                }
                if (!(element instanceof JpsCompositePackagingElement)) break block6;
                for (JpsPackagingElement child : ((JpsCompositePackagingElement)element).getChildren()) {
                    JpsArtifactUtil.processPackagingElements(child, processor, processed);
                }
                break block7;
            }
            if (!(element instanceof JpsComplexPackagingElement)) break block7;
            for (JpsPackagingElement child : ((JpsComplexPackagingElement)element).getSubstitution()) {
                JpsArtifactUtil.processPackagingElements(child, processor, processed);
            }
        }
        return true;
    }

    public static boolean isArchiveName(String name) {
        return name.length() >= 4 && name.charAt(name.length() - 4) == '.' && StringUtil.endsWithIgnoreCase((String)name, (String)"ar");
    }

    public static Set<JpsModule> getModulesIncludedInArtifacts(@NotNull Collection<? extends JpsArtifact> artifacts) {
        if (artifacts == null) {
            JpsArtifactUtil.$$$reportNull$$$0(4);
        }
        THashSet modules = new THashSet();
        for (JpsArtifact jpsArtifact : artifacts) {
            JpsArtifactUtil.processPackagingElements((JpsPackagingElement)jpsArtifact.getRootElement(), (Processor<? super JpsPackagingElement>)((Processor)arg_0 -> JpsArtifactUtil.lambda$getModulesIncludedInArtifacts$0((Set)modules, arg_0)));
        }
        return modules;
    }

    private static /* synthetic */ boolean lambda$getModulesIncludedInArtifacts$0(Set modules, JpsPackagingElement element) {
        if (element instanceof JpsModuleOutputPackagingElement) {
            ContainerUtil.addIfNotNull((Collection)modules, (Object)((JpsModule)((JpsModuleOutputPackagingElement)element).getModuleReference().resolve()));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/impl/JpsArtifactUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processPackagingElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getModulesIncludedInArtifacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

