/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.JiraVersion;
import com.intellij.tasks.jira.rest.JiraRestTask;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.util.containers.ContainerUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraRestApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraRestApi.class);

    public static JiraRestApi fromJiraVersion(@NotNull JiraVersion jiraVersion, @NotNull JiraRepository repository) {
        if (jiraVersion == null) {
            JiraRestApi.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            JiraRestApi.$$$reportNull$$$0(1);
        }
        if (jiraVersion.getMajorNumber() == 4 && jiraVersion.getMinorNumber() >= 2) {
            return new JiraRestApi20Alpha1(repository);
        }
        if (jiraVersion.getMajorNumber() >= 5) {
            return new JiraRestApi2(repository);
        }
        LOG.warn("JIRA below 4.2.0 doesn't support REST API (" + jiraVersion + " used)");
        return null;
    }

    public static JiraRestApi fromJiraVersion(@NotNull String version, @NotNull JiraRepository repository) {
        if (version == null) {
            JiraRestApi.$$$reportNull$$$0(2);
        }
        if (repository == null) {
            JiraRestApi.$$$reportNull$$$0(3);
        }
        return JiraRestApi.fromJiraVersion(new JiraVersion(version), repository);
    }

    protected JiraRestApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            JiraRestApi.$$$reportNull$$$0(4);
        }
        super(repository);
    }

    @Override
    @NotNull
    public final List<Task> findTasks(@NotNull String jql, int max) throws Exception {
        if (jql == null) {
            JiraRestApi.$$$reportNull$$$0(5);
        }
        GetMethod method = this.getMultipleIssuesSearchMethod(jql, max);
        String response = this.myRepository.executeMethod((HttpMethod)method);
        List<JiraIssue> issues = this.parseIssues(response);
        List list = ContainerUtil.map(issues, issue -> new JiraRestTask((JiraIssue)issue, (TaskRepository)this.myRepository));
        if (list == null) {
            JiraRestApi.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @Nullable
    public final JiraRestTask findTask(@NotNull String key) throws Exception {
        if (key == null) {
            JiraRestApi.$$$reportNull$$$0(7);
        }
        GetMethod method = this.getSingleIssueSearchMethod(key);
        try {
            return new JiraRestTask(this.parseIssue(this.myRepository.executeMethod((HttpMethod)method)), (TaskRepository)this.myRepository);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    protected GetMethod getSingleIssueSearchMethod(String key) {
        return new GetMethod(this.myRepository.getRestUrl("issue", key));
    }

    @NotNull
    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = new GetMethod(this.myRepository.getRestUrl("search"));
        method.setQueryString(new NameValuePair[]{new NameValuePair("jql", jql), new NameValuePair("maxResults", String.valueOf(max))});
        GetMethod getMethod = method;
        if (getMethod == null) {
            JiraRestApi.$$$reportNull$$$0(8);
        }
        return getMethod;
    }

    @NotNull
    protected abstract List<JiraIssue> parseIssues(String var1);

    @Nullable
    protected abstract JiraIssue parseIssue(String var1);

    @Override
    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            JiraRestApi.$$$reportNull$$$0(9);
        }
        if (state == null) {
            JiraRestApi.$$$reportNull$$$0(10);
        }
        String requestBody = this.getRequestForStateTransition(state);
        LOG.debug(String.format("Transition: %s -> %s, request: %s", task.getState(), state, requestBody));
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "transitions"));
        method.setRequestEntity(JiraRestApi.createJsonEntity(requestBody));
        this.myRepository.executeMethod((HttpMethod)method);
    }

    @Nullable
    protected abstract String getRequestForStateTransition(@NotNull CustomTaskState var1);

    protected static RequestEntity createJsonEntity(String requestBody) {
        try {
            return new StringRequestEntity(requestBody, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding is not supported");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jiraVersion";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jql";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/rest/JiraRestApi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/rest/JiraRestApi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleIssuesSearchMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromJiraVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTasks";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

