/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.CharTable;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.MultiFileNsDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlPsiUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class XmlTagDelegate {
    private static final Logger LOG = Logger.getInstance(XmlTagDelegate.class);
    @NonNls
    private static final String XML_NS_PREFIX = "xml";
    private static final Key<CachedValue<IdempotenceChecker.ResultWithLog<XmlTag[]>>> SUBTAGS_WITH_INCLUDES_KEY = Key.create((String)"subtags with includes");
    private static final Key<CachedValue<IdempotenceChecker.ResultWithLog<XmlTag[]>>> SUBTAGS_WITHOUT_INCLUDES_KEY = Key.create((String)"subtags without includes");
    private static final Comparator<TextRange> RANGE_COMPARATOR = Comparator.comparingInt(TextRange::getStartOffset);
    @NotNull
    protected final XmlTag myTag;
    private volatile String myName;
    private volatile String myLocalName;
    private volatile TextRange[] myTextElements;
    private volatile Map<String, String> myAttributeValueMap;
    private volatile Boolean myHasNamespaceDeclarations;

    public XmlTagDelegate(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(0);
        }
        this.myTag = tag;
    }

    protected abstract void deleteChildInternalSuper(@NotNull ASTNode var1);

    protected abstract TreeElement addInternalSuper(TreeElement var1, ASTNode var2, @Nullable ASTNode var3, @Nullable Boolean var4);

    protected XmlTag createTag(String name, String tagValue) {
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createTagFromText(XmlTagUtil.composeTagText((String)name, (String)tagValue));
    }

    protected XmlAttribute createAttribute(@NotNull String qname, @NotNull String value) {
        if (qname == null) {
            XmlTagDelegate.$$$reportNull$$$0(1);
        }
        if (value == null) {
            XmlTagDelegate.$$$reportNull$$$0(2);
        }
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createAttribute(qname, value, (PsiElement)this.myTag);
    }

    protected XmlTag createTagFromText(String text) {
        return XmlElementFactory.getInstance((Project)this.myTag.getProject()).createTagFromText((CharSequence)text);
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        attributesValueMap.put(name, value);
    }

    public boolean equals(Object obj) {
        return obj instanceof XmlTagDelegate && ((XmlTagDelegate)obj).myTag == this.myTag;
    }

    public int hashCode() {
        return this.myTag.hashCode();
    }

    @Nullable
    private static XmlNSDescriptor getDtdDescriptor(@NotNull XmlFile containingFile) {
        XmlDocument document;
        if (containingFile == null) {
            XmlTagDelegate.$$$reportNull$$$0(3);
        }
        if ((document = containingFile.getDocument()) == null) {
            return null;
        }
        String url = XmlUtil.getDtdUri(document);
        if (url == null) {
            return null;
        }
        return document.getDefaultNSDescriptor(url, true);
    }

    @Nullable
    private static String getNSVersion(@Nullable String ns, @NotNull XmlTag xmlTag) {
        String versionValue;
        if (xmlTag == null) {
            XmlTagDelegate.$$$reportNull$$$0(4);
        }
        if ((versionValue = xmlTag.getAttributeValue("version")) != null && xmlTag.getNamespace().equals(ns)) {
            return versionValue;
        }
        return null;
    }

    PsiReference @NotNull [] getDefaultReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlTagDelegate.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        if (hints == PsiReferenceService.Hints.NO_HINTS) {
            PsiReference[] psiReferenceArray = (PsiReference[])((PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this.myTag, () -> CachedValueProvider.Result.create((Object)this.getReferencesImpl(PsiReferenceService.Hints.NO_HINTS), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(this.myTag)}))).clone();
            if (psiReferenceArray == null) {
                XmlTagDelegate.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }
        return this.getReferencesImpl(hints);
    }

    private PsiReference @NotNull [] getReferencesImpl(@NotNull PsiReferenceService.Hints hints) {
        boolean inEndTag;
        boolean inStartTag;
        ASTNode startTagName;
        if (hints == null) {
            XmlTagDelegate.$$$reportNull$$$0(7);
        }
        if ((startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myTag.getNode())) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                XmlTagDelegate.$$$reportNull$$$0(8);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this.myTag.getNode());
        SmartList refs = new SmartList();
        String prefix = this.myTag.getNamespacePrefix();
        boolean bl = inStartTag = hints.offsetInElement == null || XmlTagDelegate.childContainsOffset(startTagName.getPsi(), hints.offsetInElement);
        if (inStartTag) {
            TagNameReference startTagRef = TagNameReference.createTagNameReference((XmlElement)this.myTag, startTagName, true);
            if (startTagRef != null) {
                refs.add(startTagRef);
            }
            if (!prefix.isEmpty()) {
                refs.addAll(this.createPrefixReferences(startTagName, prefix, startTagRef));
            }
        }
        boolean bl2 = inEndTag = endTagName != null && (hints.offsetInElement == null || XmlTagDelegate.childContainsOffset(endTagName.getPsi(), hints.offsetInElement));
        if (inEndTag) {
            TagNameReference endTagRef = TagNameReference.createTagNameReference((XmlElement)this.myTag, endTagName, false);
            if (endTagRef != null) {
                refs.add(endTagRef);
            }
            if (StringUtil.isNotEmpty((String)(prefix = this.getNamespacePrefix(endTagName.getText())))) {
                refs.addAll(this.createPrefixReferences(endTagName, prefix, endTagRef));
            }
        }
        if (hints.offsetInElement == null || inStartTag || inEndTag || this.isInsideXmlText(hints.offsetInElement)) {
            Collections.addAll(refs, ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myTag, (PsiReferenceService.Hints)hints));
        }
        PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(9);
        }
        return psiReferenceArray;
    }

    private static boolean childContainsOffset(@NotNull PsiElement child, int offsetInTag) {
        if (child == null) {
            XmlTagDelegate.$$$reportNull$$$0(10);
        }
        return child.getStartOffsetInParent() <= offsetInTag && offsetInTag <= child.getStartOffsetInParent() + child.getTextLength();
    }

    private boolean isInsideXmlText(int offsetInTag) {
        TextRange[] ranges = this.getValueTextRanges();
        if (ranges.length == 0) {
            return false;
        }
        if (offsetInTag < ranges[0].getStartOffset() || offsetInTag > ranges[ranges.length - 1].getEndOffset()) {
            return false;
        }
        int i = Arrays.binarySearch(ranges, TextRange.from((int)offsetInTag, (int)0), RANGE_COMPARATOR);
        return i >= 0 || ranges[-i - 2].containsOffset(offsetInTag);
    }

    private TextRange @NotNull [] getValueTextRanges() {
        TextRange[] elements = this.myTextElements;
        if (elements == null) {
            SmartList list = new SmartList();
            for (ASTNode child = this.myTag.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                PsiElement psi = child.getPsi();
                if (!(psi instanceof XmlText)) continue;
                list.add(TextRange.from((int)psi.getStartOffsetInParent(), (int)psi.getTextLength()));
            }
            this.myTextElements = elements = list.toArray(TextRange.EMPTY_ARRAY);
        }
        if (elements == null) {
            XmlTagDelegate.$$$reportNull$$$0(11);
        }
        return elements;
    }

    protected Collection<PsiReference> createPrefixReferences(@NotNull ASTNode startTagName, @NotNull String prefix, @Nullable TagNameReference tagRef) {
        if (startTagName == null) {
            XmlTagDelegate.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            XmlTagDelegate.$$$reportNull$$$0(13);
        }
        return Collections.singleton(new SchemaPrefixReference((XmlElement)this.myTag, TextRange.from((int)(startTagName.getStartOffset() - this.myTag.getNode().getStartOffset()), (int)prefix.length()), prefix, tagRef));
    }

    XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        XmlNSDescriptor value;
        XmlNSDescriptor descriptor;
        XmlTag parentTag = this.myTag.getParentTag();
        if (parentTag == null && namespace.equals("http://www.w3.org/1999/xhtml") && (descriptor = XmlTagDelegate.getDtdDescriptor(XmlUtil.getContainingFile((PsiElement)this.myTag))) != null) {
            return descriptor;
        }
        descriptor = this.getNSDescriptorMap().get(namespace);
        if (descriptor != null && (value = (XmlNSDescriptor)descriptor.getValue()) != null) {
            return value;
        }
        if (parentTag == null) {
            XmlDocument parentOfType = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)this.myTag, XmlDocument.class);
            if (parentOfType == null) {
                return null;
            }
            return parentOfType.getDefaultNSDescriptor(namespace, strict);
        }
        return parentTag.getNSDescriptor(namespace, strict);
    }

    void collapseIfEmpty() {
        XmlTag[] tags = this.myTag.getSubTags();
        if (tags.length > 0) {
            return;
        }
        ASTNode closingName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(this.myTag.getNode());
        ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this.myTag.getNode());
        if (closingName == null || startTagEnd == null) {
            return;
        }
        ASTNode closingBracket = closingName.getTreeNext();
        ASTNode tag = this.myTag.getNode();
        tag.removeRange(startTagEnd, closingBracket);
        LeafElement emptyTagEnd = Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END, (CharSequence)"/>", (int)0, (int)2, null, (PsiManager)this.myTag.getManager());
        tag.replaceChild(closingBracket, (ASTNode)emptyTagEnd);
    }

    @NotNull
    private Map<String, NullableLazyValue<XmlNSDescriptor>> getNSDescriptorMap() {
        XmlTag tag = this.myTag;
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)tag, () -> CachedValueProvider.Result.create(XmlTagDelegate.computeNsDescriptorMap(tag), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(tag)}));
        if (map == null) {
            XmlTagDelegate.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    protected String getNamespacePrefix(@NotNull String name) {
        if (name == null) {
            XmlTagDelegate.$$$reportNull$$$0(15);
        }
        String string = XmlUtil.findPrefixByQualifiedName(name);
        if (string == null) {
            XmlTagDelegate.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static Map<String, NullableLazyValue<XmlNSDescriptor>> computeNsDescriptorMap(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(17);
        }
        Map<String, NullableLazyValue<XmlNSDescriptor>> map = null;
        String noNamespaceDeclaration = tag.getAttributeValue("noNamespaceSchemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        String schemaLocationDeclaration = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance");
        boolean hasNamespaceDeclarations = tag.hasNamespaceDeclarations();
        if (noNamespaceDeclaration != null) {
            map = XmlTagDelegate.initializeSchema(tag, "", null, Collections.singleton(noNamespaceDeclaration), null, hasNamespaceDeclarations);
        }
        if (schemaLocationDeclaration != null) {
            StringTokenizer tokenizer = new StringTokenizer(schemaLocationDeclaration);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                map = XmlTagDelegate.initializeSchema(tag, uri, XmlTagDelegate.getNSVersion(uri, tag), Collections.singleton(tokenizer.nextToken()), map, hasNamespaceDeclarations);
            }
        }
        if (hasNamespaceDeclarations) {
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String ns = attribute.getValue();
                if (ns == null) {
                    ns = "";
                }
                ns = tag.getRealNs(ns);
                if (map != null && map.containsKey(ns)) continue;
                Set<String> locations = XmlTagDelegate.getNsLocations(tag, ns);
                map = XmlTagDelegate.initializeSchema(tag, ns, XmlTagDelegate.getNSVersion(ns, tag), locations, map, true);
            }
        }
        Map<String, NullableLazyValue<XmlNSDescriptor>> map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            XmlTagDelegate.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @NotNull
    private static Map<String, NullableLazyValue<XmlNSDescriptor>> initializeSchema(@NotNull XmlTag tag, @Nullable String namespace, @Nullable String version, @NotNull Set<String> fileLocations, @Nullable Map<String, NullableLazyValue<XmlNSDescriptor>> map, boolean nsDecl) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(19);
        }
        if (fileLocations == null) {
            XmlTagDelegate.$$$reportNull$$$0(20);
        }
        if (map == null) {
            map = new HashMap<String, NullableLazyValue<XmlNSDescriptor>>();
        }
        map.put(namespace, (NullableLazyValue<XmlNSDescriptor>)NullableLazyValue.createValue(() -> {
            List descriptors = ContainerUtil.mapNotNull((Collection)fileLocations, s -> XmlTagDelegate.getDescriptor(tag, XmlTagDelegate.retrieveFile(tag, s, version, namespace, nsDecl), s, namespace));
            XmlNSDescriptor descriptor = null;
            if (descriptors.size() == 1) {
                descriptor = (XmlNSDescriptor)descriptors.get(0);
            } else if (descriptors.size() > 1) {
                descriptor = new MultiFileNsDescriptor(ContainerUtil.map((Collection)descriptors, descriptor1 -> (XmlNSDescriptorImpl)descriptor1));
            }
            if (descriptor == null) {
                return null;
            }
            XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)tag);
            if (extension != null) {
                String prefix = tag.getPrefixByNamespace(namespace);
                descriptor = extension.wrapNSDescriptor(tag, (String)ObjectUtils.notNull((Object)prefix, (Object)""), descriptor);
            }
            return descriptor;
        }));
        Map<String, NullableLazyValue<XmlNSDescriptor>> map2 = map;
        if (map2 == null) {
            XmlTagDelegate.$$$reportNull$$$0(21);
        }
        return map2;
    }

    @Nullable
    private static XmlNSDescriptor getDescriptor(@NotNull XmlTag tag, @Nullable XmlFile currentFile, @NotNull String fileLocation, @Nullable String namespace) {
        PsiMetaOwner currentOwner;
        XmlDocument document;
        XmlNSDescriptor descriptor;
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(22);
        }
        if (fileLocation == null) {
            XmlTagDelegate.$$$reportNull$$$0(23);
        }
        if ((descriptor = XmlTagDelegate.getImplicitNamespaceDescriptor(tag, fileLocation)) != null) {
            return descriptor;
        }
        if (currentFile == null && (document = XmlUtil.getContainingFile((PsiElement)tag).getDocument()) != null) {
            String defaultValue;
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor elementDescriptor;
            String uri = XmlUtil.getDtdUri(document);
            if (uri != null) {
                XmlFile containingFile = XmlUtil.getContainingFile((PsiElement)document);
                XmlFile xmlFile = XmlUtil.findNamespace((PsiFile)containingFile, uri);
                XmlDocument xmlDocument = xmlFile == null ? null : xmlFile.getDocument();
                descriptor = (XmlNSDescriptor)(xmlDocument == null ? null : xmlDocument.getMetaData());
            }
            if (descriptor instanceof com.intellij.xml.impl.dtd.XmlNSDescriptorImpl && (elementDescriptor = descriptor.getElementDescriptor(tag)) != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor("xmlns", tag)) != null && attributeDescriptor.isFixed() && (defaultValue = attributeDescriptor.getDefaultValue()) != null && defaultValue.equals(namespace)) {
                return descriptor;
            }
        }
        if ((currentOwner = XmlTagDelegate.retrieveOwner(tag, currentFile, namespace)) != null) {
            return (XmlNSDescriptor)currentOwner.getMetaData();
        }
        return null;
    }

    @Nullable
    private static XmlNSDescriptor getImplicitNamespaceDescriptor(@NotNull XmlTag tag, @NotNull String ns) {
        PsiFile file;
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(24);
        }
        if (ns == null) {
            XmlTagDelegate.$$$reportNull$$$0(25);
        }
        if ((file = tag.getContainingFile()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            for (ImplicitNamespaceDescriptorProvider provider : ImplicitNamespaceDescriptorProvider.EP_NAME.getExtensionList()) {
                XmlNSDescriptor nsDescriptor = provider.getNamespaceDescriptor(module, ns, file);
                if (nsDescriptor == null) continue;
                return nsDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private static XmlFile retrieveFile(@Nullable XmlTag tag, @NotNull String fileLocation, @Nullable String version, String namespace, boolean nsDecl) {
        String targetNs;
        if (fileLocation == null) {
            XmlTagDelegate.$$$reportNull$$$0(26);
        }
        if (fileLocation.equals(targetNs = XmlUtil.getTargetSchemaNsFromTag(tag))) {
            return null;
        }
        XmlFile file = XmlUtil.getContainingFile((PsiElement)tag);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(fileLocation, (PsiFile)file, version);
        if (psiFile instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return XmlNamespaceIndex.guessSchema(namespace, nsDecl ? null : tag.getLocalName(), version, fileLocation, (PsiFile)file);
    }

    @Nullable
    private static PsiMetaOwner retrieveOwner(@Nullable XmlTag tag, @Nullable XmlFile file, @Nullable String namespace) {
        if (file == null) {
            return namespace != null && namespace.equals(XmlUtil.getTargetSchemaNsFromTag(tag)) ? tag : null;
        }
        return (PsiMetaOwner)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> ((XmlFile)file).getDocument());
    }

    @Nullable
    XmlElementDescriptor getDescriptor() {
        return (XmlElementDescriptor)CachedValuesManager.getCachedValue((PsiElement)this.myTag, (CachedValueProvider)new CachedValueProvider<XmlElementDescriptor>(){

            public CachedValueProvider.Result<XmlElementDescriptor> compute() {
                XmlElementDescriptor descriptor = (XmlElementDescriptor)RecursionManager.doPreventingRecursion((Object)XmlTagDelegate.this.myTag, (boolean)true, XmlTagDelegate.this::computeElementDescriptor);
                return CachedValueProvider.Result.create((Object)descriptor, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, XmlTagDelegate.externalResourceModificationTracker(XmlTagDelegate.this.myTag)});
            }

            public String toString() {
                return "XmlTag.getDescriptor(" + XmlTagDelegate.this.myTag.getText() + ")";
            }
        });
    }

    @NotNull
    private static ModificationTracker externalResourceModificationTracker(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(27);
        }
        Project project = tag.getProject();
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        ModificationTracker modificationTracker = () -> manager.getModificationCount(project);
        if (modificationTracker == null) {
            XmlTagDelegate.$$$reportNull$$$0(28);
        }
        return modificationTracker;
    }

    @Nullable
    protected XmlElementDescriptor computeElementDescriptor() {
        XmlElementDescriptor fromParent;
        XmlElementDescriptor descriptor;
        XmlTag parent;
        for (XmlElementDescriptorProvider provider : XmlElementDescriptorProvider.EP_NAME.getExtensionList()) {
            XmlElementDescriptor elementDescriptor = provider.getDescriptor(this.myTag);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        String namespace = this.myTag.getNamespace();
        if ("".equals(namespace) && (parent = this.myTag.getParentTag()) != null && (descriptor = parent.getDescriptor()) != null && (fromParent = descriptor.getElementDescriptor(this.myTag, parent)) != null && !(fromParent instanceof AnyXmlElementDescriptor)) {
            return fromParent;
        }
        XmlElementDescriptor elementDescriptor = null;
        XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(namespace, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Descriptor for namespace " + namespace + " is " + (nsDescriptor != null ? nsDescriptor.getClass().getCanonicalName() : "NULL"));
        }
        if (nsDescriptor != null && (!DumbService.getInstance((Project)this.myTag.getProject()).isDumb() || DumbService.isDumbAware((Object)nsDescriptor))) {
            elementDescriptor = nsDescriptor.getElementDescriptor(this.myTag);
        }
        if (elementDescriptor == null) {
            return XmlUtil.findXmlDescriptorByType(this.myTag);
        }
        return elementDescriptor;
    }

    @NotNull
    String getName() {
        String name = this.myName;
        if (name == null) {
            ASTNode nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myTag.getNode());
            name = nameElement != null ? nameElement.getText() : "";
            this.myName = name;
        }
        String string = name;
        if (string == null) {
            XmlTagDelegate.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        TreeElement treeElement;
        if (name == null) {
            XmlTagDelegate.$$$reportNull$$$0(30);
        }
        XmlTag dummyTag = this.createTag(name, "aa");
        ASTNode tag = this.myTag.getNode();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)tag);
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag);
        LOG.assertTrue(child != null, (Object)("It seems '" + name + "' is not a valid tag name"));
        TreeElement tagElement = (TreeElement)XmlChildRole.START_TAG_NAME_FINDER.findChild(dummyTag.getNode());
        LOG.assertTrue(tagElement != null, (Object)("What's wrong with it? '" + name + "'"));
        tag.replaceChild(child, (ASTNode)ChangeUtil.copyElement((TreeElement)tagElement, (CharTable)charTableByTree));
        ASTNode childByRole = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(tag);
        if (childByRole != null && (treeElement = (TreeElement)XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(dummyTag.getNode())) != null) {
            tag.replaceChild(childByRole, (ASTNode)ChangeUtil.copyElement((TreeElement)treeElement, (CharTable)charTableByTree));
        }
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            XmlTagDelegate.$$$reportNull$$$0(31);
        }
        return xmlTag;
    }

    private void processChildren(@NotNull PsiElementProcessor<? super PsiElement> processor) {
        if (processor == null) {
            XmlTagDelegate.$$$reportNull$$$0(32);
        }
        XmlPsiUtil.processXmlElementChildren((XmlElement)this.myTag, processor, false);
    }

    XmlAttribute @NotNull [] calculateAttributes() {
        ArrayList result = new ArrayList(10);
        this.processChildren((PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlAttribute) {
                result.add((XmlAttribute)element);
            }
            return !(element instanceof XmlToken) || ((XmlToken)element).getTokenType() != XmlTokenType.XML_TAG_END;
        }));
        XmlAttribute[] xmlAttributeArray = result.toArray(XmlAttribute.EMPTY_ARRAY);
        if (xmlAttributeArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(33);
        }
        return xmlAttributeArray;
    }

    @Contract(value="null->null")
    protected String getAttributeValue(String qname) {
        Map<String, String> map = this.myAttributeValueMap;
        if (map == null) {
            map = new HashMap<String, String>();
            for (XmlAttribute attribute : this.myTag.getAttributes()) {
                this.cacheOneAttributeValue(attribute.getName(), attribute.getValue(), map);
            }
            this.myAttributeValueMap = map;
        }
        return map.get(qname);
    }

    @Nullable
    protected String getAttributeValue(@Nullable String _name, @Nullable String namespace) {
        if (namespace == null) {
            return this.myTag.getAttributeValue(_name);
        }
        XmlTag current = this.myTag;
        while (true) {
            PsiElement parent;
            List keysByValue;
            BidirectionalMap<String, String> map;
            if ((map = XmlTagDelegate.getNamespaceMap(current)) != null && (keysByValue = map.getKeysByValue((Object)namespace)) != null && !keysByValue.isEmpty()) {
                for (String prefix : keysByValue) {
                    String value;
                    if (prefix == null || prefix.isEmpty() || (value = this.myTag.getAttributeValue(prefix + ":" + _name)) == null) continue;
                    return value;
                }
            }
            if (!((parent = current.getParent()) instanceof XmlTag)) break;
            current = (XmlTag)parent;
        }
        if (namespace.isEmpty() || this.myTag.getNamespace().equals(namespace)) {
            return this.myTag.getAttributeValue(_name);
        }
        return null;
    }

    XmlTag @NotNull [] getSubTags(boolean processIncludes) {
        Key<CachedValue<IdempotenceChecker.ResultWithLog<XmlTag[]>>> key = processIncludes ? SUBTAGS_WITH_INCLUDES_KEY : SUBTAGS_WITHOUT_INCLUDES_KEY;
        IdempotenceChecker.ResultWithLog cached = (IdempotenceChecker.ResultWithLog)CachedValuesManager.getCachedValue((PsiElement)this.myTag, key, () -> CachedValueProvider.Result.create((Object)IdempotenceChecker.computeWithLogging(() -> this.calcSubTags(processIncludes)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        XmlTag[] xmlTagArray = (XmlTag[])((XmlTag[])cached.getResult()).clone();
        if (xmlTagArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(34);
        }
        return xmlTagArray;
    }

    protected XmlTag @NotNull [] calcSubTags(boolean processIncludes) {
        ArrayList result = new ArrayList();
        XmlPsiUtil.processXmlElements((XmlElement)this.myTag, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlTag) {
                PsiUtilCore.ensureValid((PsiElement)element);
                result.add((XmlTag)element);
            }
            return true;
        }), false, false, this.myTag.getContainingFile(), processIncludes);
        XmlTag[] xmlTagArray = result.toArray(XmlTag.EMPTY);
        if (xmlTagArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(35);
        }
        return xmlTagArray;
    }

    protected XmlTag @NotNull [] findSubTags(@NotNull String name, @Nullable String namespace) {
        if (name == null) {
            XmlTagDelegate.$$$reportNull$$$0(36);
        }
        XmlTag[] subTags = this.myTag.getSubTags();
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlTag subTag : subTags) {
            if (namespace == null) {
                if (!name.equals(subTag.getName())) continue;
                result.add(subTag);
                continue;
            }
            if (!name.equals(subTag.getLocalName()) || !namespace.equals(subTag.getNamespace())) continue;
            result.add(subTag);
        }
        XmlTag[] xmlTagArray = result.toArray(XmlTag.EMPTY);
        if (xmlTagArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(37);
        }
        return xmlTagArray;
    }

    @Nullable
    XmlTag findFirstSubTag(@NotNull String name) {
        XmlTag[] subTags;
        if (name == null) {
            XmlTagDelegate.$$$reportNull$$$0(38);
        }
        if ((subTags = this.myTag.findSubTags(name)).length > 0) {
            return subTags[0];
        }
        return null;
    }

    @Nullable
    XmlAttribute getAttribute(@Nullable String name, @Nullable String namespace) {
        if (name != null && name.indexOf(58) != -1 || namespace == null || "".equals(namespace)) {
            return this.myTag.getAttribute(name);
        }
        String prefix = this.myTag.getPrefixByNamespace(namespace);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return this.myTag.getAttribute(prefix + ":" + name);
    }

    @Nullable
    XmlAttribute getAttribute(@Nullable String qname) {
        if (qname == null) {
            return null;
        }
        XmlAttribute[] attributes = this.myTag.getAttributes();
        boolean caseSensitive = this.myTag.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            if (!(child instanceof LeafElement)) continue;
            LeafElement attrNameElement = (LeafElement)child;
            if ((!caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname)) && (caseSensitive || !Comparing.equal((CharSequence)attrNameElement.getChars(), (CharSequence)qname, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    protected String getNamespaceByPrefix(String prefix) {
        String result;
        String ns;
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        if (map != null && (ns = (String)map.get((Object)prefix)) != null) {
            String string = ns;
            if (string == null) {
                XmlTagDelegate.$$$reportNull$$$0(39);
            }
            return string;
        }
        XmlTag parentTag = this.myTag.getParentTag();
        if (parentTag != null) {
            String string = parentTag.getNamespaceByPrefix(prefix);
            if (string == null) {
                XmlTagDelegate.$$$reportNull$$$0(40);
            }
            return string;
        }
        if (XML_NS_PREFIX.equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (!prefix.isEmpty() && !this.myTag.hasNamespaceDeclarations() && this.myTag.getNamespacePrefix().equals(prefix) && (result = (String)RecursionManager.doPreventingRecursion((Object)Trinity.create((Object)"getNsByPrefix", (Object)this.myTag, (Object)prefix), (boolean)true, () -> {
            String nameFromRealDescriptor;
            String nsFromEmptyPrefix = this.myTag.getNamespaceByPrefix("");
            if (nsFromEmptyPrefix.isEmpty()) {
                return nsFromEmptyPrefix;
            }
            XmlNSDescriptor nsDescriptor = this.myTag.getNSDescriptor(nsFromEmptyPrefix, false);
            XmlElementDescriptor descriptor = nsDescriptor != null ? nsDescriptor.getElementDescriptor(this.myTag) : null;
            String string = nameFromRealDescriptor = descriptor != null && descriptor.getDeclaration() != null && descriptor.getDeclaration().isPhysical() ? descriptor.getName() : "";
            if (nameFromRealDescriptor.equals(this.myTag.getName())) {
                return nsFromEmptyPrefix;
            }
            return "";
        })) != null) {
            String string = result;
            if (string == null) {
                XmlTagDelegate.$$$reportNull$$$0(41);
            }
            return string;
        }
        return "";
    }

    @Nullable
    protected String getPrefixByNamespace(@Nullable String namespace) {
        XmlTag parentTag;
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        if (map != null) {
            String ns;
            List keysByValue = map.getKeysByValue((Object)namespace);
            String string = ns = keysByValue == null || keysByValue.isEmpty() ? null : (String)keysByValue.get(0);
            if (ns != null) {
                return ns;
            }
        }
        if ((parentTag = this.myTag.getParentTag()) != null) {
            return parentTag.getPrefixByNamespace(namespace);
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return XML_NS_PREFIX;
        }
        return null;
    }

    String @NotNull [] knownNamespaces() {
        PsiElement parentElement = this.myTag.getParent();
        BidirectionalMap<String, String> map = XmlTagDelegate.getNamespaceMap(this.myTag);
        Set known = Collections.emptySet();
        if (map != null) {
            known = new HashSet(map.values());
        }
        if (parentElement instanceof XmlTag) {
            if (known.isEmpty()) {
                String[] stringArray = ((XmlTag)parentElement).knownNamespaces();
                if (stringArray == null) {
                    XmlTagDelegate.$$$reportNull$$$0(42);
                }
                return stringArray;
            }
            ContainerUtil.addAll(known, (Object[])((XmlTag)parentElement).knownNamespaces());
        } else {
            XmlTag rootTag;
            XmlFile xmlFile;
            XmlExtension xmlExtension = XmlExtension.getExtensionByElement((PsiElement)this.myTag);
            if (xmlExtension != null && (xmlFile = xmlExtension.getContainingFile((PsiElement)this.myTag)) != null && (rootTag = xmlFile.getRootTag()) != null && rootTag != this.myTag) {
                if (known.isEmpty()) {
                    String[] stringArray = rootTag.knownNamespaces();
                    if (stringArray == null) {
                        XmlTagDelegate.$$$reportNull$$$0(43);
                    }
                    return stringArray;
                }
                ContainerUtil.addAll(known, (Object[])rootTag.knownNamespaces());
            }
        }
        String[] stringArray = ArrayUtilRt.toStringArray(known);
        if (stringArray == null) {
            XmlTagDelegate.$$$reportNull$$$0(44);
        }
        return stringArray;
    }

    @Nullable
    private static BidirectionalMap<String, String> getNamespaceMap(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(45);
        }
        return (BidirectionalMap)CachedValuesManager.getCachedValue((PsiElement)tag, () -> CachedValueProvider.Result.create(XmlTagDelegate.computeNamespaceMap(tag), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static BidirectionalMap<String, String> computeNamespaceMap(@NotNull XmlTag tag) {
        String[][] namespacesFromDocument;
        XmlExtension extension;
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(46);
        }
        BidirectionalMap map = null;
        PsiElement parent = tag.getParent();
        boolean hasNamespaceDeclarations = tag.hasNamespaceDeclarations();
        if (hasNamespaceDeclarations) {
            XmlAttribute[] attributes;
            map = new BidirectionalMap();
            for (XmlAttribute attribute : attributes = tag.getAttributes()) {
                if (!attribute.isNamespaceDeclaration()) continue;
                String name = attribute.getName();
                int splitIndex = name.indexOf(58);
                String value = tag.getRealNs(attribute.getValue());
                if (value == null) continue;
                if (splitIndex < 0) {
                    map.put((Object)"", (Object)value);
                    continue;
                }
                map.put((Object)XmlUtil.findLocalNameByQualifiedName(name), (Object)value);
            }
        }
        if (parent instanceof XmlDocument && (extension = XmlExtension.getExtensionByElement(parent)) != null && (namespacesFromDocument = extension.getNamespacesFromDocument((XmlDocument)parent, hasNamespaceDeclarations)) != null) {
            if (map == null) {
                map = new BidirectionalMap();
            }
            for (String[] prefix2ns : namespacesFromDocument) {
                if (map.containsKey((Object)prefix2ns[0])) continue;
                map.put((Object)prefix2ns[0], (Object)tag.getRealNs(prefix2ns[1]));
            }
        }
        return map;
    }

    @NotNull
    private static Set<String> getNsLocations(@NotNull XmlTag tag, @Nullable String ns) {
        if (tag == null) {
            XmlTagDelegate.$$$reportNull$$$0(47);
        }
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            Set<String> set = Collections.singleton(XmlUtil.getDefaultXhtmlNamespace(tag.getProject()));
            if (set == null) {
                XmlTagDelegate.$$$reportNull$$$0(48);
            }
            return set;
        }
        HashSet<String> locations = new HashSet<String>();
        if (XmlNSDescriptorImpl.equalsToSchemaName(tag, "schema") && ns != null) {
            for (XmlTag subTag : tag.getSubTags()) {
                if (!XmlNSDescriptorImpl.equalsToSchemaName(subTag, "import") || !ns.equals(subTag.getAttributeValue("namespace"))) continue;
                String location = subTag.getAttributeValue("schemaLocation");
                ContainerUtil.addIfNotNull(locations, (Object)location);
            }
        }
        if (locations.isEmpty()) {
            locations.add(XmlUtil.getSchemaLocation(tag, ns));
        }
        HashSet<String> hashSet = locations;
        if (hashSet == null) {
            XmlTagDelegate.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @NotNull
    String getLocalName() {
        String localName = this.myLocalName;
        if (localName == null) {
            String name = this.myTag.getName();
            this.myLocalName = localName = name.substring(name.indexOf(58) + 1);
        }
        String string = localName;
        if (string == null) {
            XmlTagDelegate.$$$reportNull$$$0(50);
        }
        return string;
    }

    boolean hasNamespaceDeclarations() {
        Boolean result = this.myHasNamespaceDeclarations;
        if (result == null) {
            this.myHasNamespaceDeclarations = result = this.calculateHasNamespaceDeclarations();
        }
        return result;
    }

    @NotNull
    private Boolean calculateHasNamespaceDeclarations() {
        Ref result = new Ref((Object)Boolean.FALSE);
        this.processChildren((PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
            if (element instanceof XmlAttribute && ((XmlAttribute)element).isNamespaceDeclaration()) {
                result.set((Object)Boolean.TRUE);
                return false;
            }
            return !(element instanceof XmlToken) || ((XmlToken)element).getTokenType() != XmlTokenType.XML_TAG_END;
        }));
        Boolean bl = (Boolean)result.get();
        if (bl == null) {
            XmlTagDelegate.$$$reportNull$$$0(51);
        }
        return bl;
    }

    @NotNull
    Map<String, String> getLocalNamespaceDeclarations() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (XmlAttribute attribute : this.myTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration() || attribute.getValue() == null) continue;
            String localName = attribute.getLocalName();
            namespaces.put(localName.equals(attribute.getName()) ? "" : localName, attribute.getValue());
        }
        HashMap<String, String> hashMap = namespaces;
        if (hashMap == null) {
            XmlTagDelegate.$$$reportNull$$$0(52);
        }
        return hashMap;
    }

    @Nullable
    XmlAttribute setAttribute(String qname, @Nullable String value) throws IncorrectOperationException {
        XmlAttribute attribute = this.myTag.getAttribute(qname);
        if (attribute != null) {
            if (value == null) {
                this.deleteChildInternal(attribute.getNode());
                return null;
            }
            attribute.setValue(value);
            return attribute;
        }
        if (value == null) {
            return null;
        }
        PsiElement xmlAttribute = this.myTag.add((PsiElement)this.createAttribute(qname, value));
        while (!(xmlAttribute instanceof XmlAttribute)) {
            xmlAttribute = xmlAttribute.getNextSibling();
        }
        return (XmlAttribute)xmlAttribute;
    }

    XmlAttribute setAttribute(String name, String namespace, String value) throws IncorrectOperationException {
        String prefix;
        if (!Objects.equals(namespace, "") && (prefix = this.myTag.getPrefixByNamespace(namespace)) != null && !prefix.isEmpty()) {
            name = prefix + ":" + (String)name;
        }
        return this.myTag.setAttribute((String)name, value);
    }

    @NotNull
    XmlTag addSubTag(@NotNull XmlTag subTag, boolean first) {
        Object[] children;
        if (subTag == null) {
            XmlTagDelegate.$$$reportNull$$$0(53);
        }
        if ((children = this.myTag.getSubTags()).length == 0) {
            children = this.myTag.getValue().getChildren();
        }
        if (children.length == 0) {
            XmlTag xmlTag = (XmlTag)this.myTag.add((PsiElement)subTag);
            if (xmlTag == null) {
                XmlTagDelegate.$$$reportNull$$$0(54);
            }
            return xmlTag;
        }
        if (first) {
            XmlTag xmlTag = (XmlTag)this.myTag.addBefore((PsiElement)subTag, (PsiElement)children[0]);
            if (xmlTag == null) {
                XmlTagDelegate.$$$reportNull$$$0(55);
            }
            return xmlTag;
        }
        XmlTag xmlTag = (XmlTag)this.myTag.addAfter((PsiElement)subTag, (PsiElement)ArrayUtil.getLastElement((Object[])children));
        if (xmlTag == null) {
            XmlTagDelegate.$$$reportNull$$$0(56);
        }
        return xmlTag;
    }

    void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            XmlTagDelegate.$$$reportNull$$$0(57);
        }
        if (child.getElementType() instanceof IXmlAttributeElementType) {
            try {
                this.deleteChildInternalSuper(child);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else {
            ASTNode treePrev = child.getTreePrev();
            ASTNode treeNext = child.getTreeNext();
            this.deleteChildInternalSuper(child);
            if (treePrev != null && treeNext != null && treePrev.getElementType() == XmlElementType.XML_TEXT && treeNext.getElementType() == XmlElementType.XML_TEXT && !TreeUtil.containsOuterLanguageElements((ASTNode)treePrev) && !TreeUtil.containsOuterLanguageElements((ASTNode)treeNext)) {
                XmlText prevText = (XmlText)treePrev.getPsi();
                XmlText nextText = (XmlText)treeNext.getPsi();
                String newValue = prevText.getValue() + nextText.getValue();
                ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                    PsiElement anchor = prevText.getPrevSibling();
                    prevText.delete();
                    nextText.delete();
                    XmlText text = (XmlText)this.myTag.addAfter((PsiElement)XmlElementFactory.getInstance((Project)this.myTag.getProject()).createDisplayText("x"), anchor);
                    text.setValue(newValue);
                }, (TreeElement)((TreeElement)this.myTag.getNode()));
            }
        }
    }

    TreeElement addInternal(@NotNull TreeElement child, @Nullable ASTNode anchor, boolean before) throws IncorrectOperationException {
        if (child == null) {
            XmlTagDelegate.$$$reportNull$$$0(58);
        }
        if (anchor != null && child.getElementType() == XmlElementType.XML_TEXT) {
            XmlText psi = null;
            if (anchor.getPsi() instanceof XmlText) {
                psi = (XmlText)anchor.getPsi();
            } else {
                ASTNode other;
                ASTNode aSTNode = other = before ? anchor.getTreePrev() : anchor.getTreeNext();
                if (other != null && other.getPsi() instanceof XmlText) {
                    before = !before;
                    psi = (XmlText)other.getPsi();
                }
            }
            if (psi != null) {
                if (before) {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), 0);
                } else {
                    psi.insertText(((XmlText)child.getPsi()).getValue(), psi.getValue().length());
                }
                return (TreeElement)psi.getNode();
            }
        }
        LOG.assertTrue(child.getPsi() instanceof XmlAttribute || child.getPsi() instanceof XmlTagChild);
        return child.getElementType() instanceof IXmlAttributeElementType ? this.insertAttribute(anchor, child, before) : (anchor == null ? this.bodyInsert(child) : this.genericInsert(child, anchor, before));
    }

    @NotNull
    private ASTNode expandTag() throws IncorrectOperationException {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myTag.getNode());
        if (endTagStart == null) {
            XmlTag tagFromText = this.createTagFromText("<" + this.myTag.getName() + "></" + this.myTag.getName() + ">");
            ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(tagFromText.getNode());
            endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagFromText.getNode());
            assert (startTagStart != null) : tagFromText.getText();
            assert (endTagStart != null) : tagFromText.getText();
            LeafElement emptyTagEnd = (LeafElement)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(this.myTag.getNode());
            if (emptyTagEnd != null) {
                this.myTag.getNode().removeChild((ASTNode)emptyTagEnd);
            }
            this.myTag.getNode().addChildren(startTagStart, null, null);
        }
        ASTNode aSTNode = endTagStart;
        if (aSTNode == null) {
            XmlTagDelegate.$$$reportNull$$$0(59);
        }
        return aSTNode;
    }

    protected TreeElement bodyInsert(TreeElement child) {
        ASTNode anchor = this.expandTag();
        if (child.getElementType() == XmlElementType.XML_TAG) {
            PsiElement declaration;
            XmlTag[] subTags = this.myTag.getSubTags();
            XmlElementDescriptor parentDescriptor = this.myTag.getDescriptor();
            PsiElement psiElement = declaration = parentDescriptor != null ? parentDescriptor.getDeclaration() : null;
            if (declaration != null && declaration.getContainingFile() != null && declaration.getContainingFile().isPhysical() && subTags.length > 0) {
                XmlElementDescriptor[] childElementDescriptors = parentDescriptor.getElementsDescriptors(this.myTag);
                int subTagNum = -1;
                for (XmlElementDescriptor childElementDescriptor : childElementDescriptors) {
                    String childElementName = childElementDescriptor.getName();
                    while (subTagNum < subTags.length - 1 && subTags[subTagNum + 1].getName().equals(childElementName)) {
                        ++subTagNum;
                    }
                    ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild((ASTNode)child);
                    if (startTagName == null || !childElementName.equals(startTagName.getText())) continue;
                    if (subTagNum >= 0) {
                        ASTNode subTag = subTags[subTagNum].getNode();
                        if (subTag.getTreeParent() != this.myTag.getNode()) {
                            XmlEntityRef entityRef = (XmlEntityRef)PsiTreeUtil.getParentOfType((PsiElement)subTags[subTagNum], XmlEntityRef.class);
                            throw new IncorrectOperationException("Can't insert subtag to the entity. Entity reference text: " + (entityRef == null ? "" : entityRef.getText()));
                        }
                        return this.addInternalSuper(child, (ASTNode)child, subTag, Boolean.FALSE);
                    }
                    ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(this.myTag.getNode());
                    return this.addInternalSuper(child, (ASTNode)child, startTagEnd, Boolean.FALSE);
                }
            } else {
                ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myTag.getNode());
                return this.addInternalSuper(child, (ASTNode)child, closingTagStart, Boolean.TRUE);
            }
        }
        return this.addInternalSuper(child, (ASTNode)child, anchor, Boolean.TRUE);
    }

    private TreeElement insertAttribute(ASTNode anchor, TreeElement child, boolean before) {
        if (anchor == null) {
            ASTNode tagNode = this.myTag.getNode();
            ASTNode startTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tagNode);
            if (startTagEnd == null) {
                startTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tagNode);
            }
            if (startTagEnd == null) {
                anchor = tagNode.getLastChildNode();
                while (anchor instanceof PsiWhiteSpace) {
                    anchor = anchor.getTreePrev();
                }
                if (anchor instanceof PsiErrorElement) {
                    LeafElement token = Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END, (CharSequence)"/>", (int)0, (int)2, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)anchor), (PsiManager)this.myTag.getManager());
                    tagNode.replaceChild(anchor, (ASTNode)token);
                    startTagEnd = token;
                }
            }
            if (startTagEnd == null) {
                anchor = XmlChildRole.START_TAG_NAME_FINDER.findChild(tagNode);
                return this.addInternalSuper(child, (ASTNode)child, anchor, Boolean.FALSE);
            }
            return this.addInternalSuper(child, (ASTNode)child, startTagEnd, Boolean.TRUE);
        }
        return this.genericInsert(child, anchor, before);
    }

    protected TreeElement genericInsert(TreeElement child, ASTNode anchor, boolean before) {
        return this.addInternalSuper(child, (ASTNode)child, anchor, before);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTagDelegate";
                break;
            }
            case 10: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startTagName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 15: 
            case 30: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLocations";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLocation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTagDelegate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultReferences";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNSDescriptorMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNsDescriptorMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeSchema";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "externalResourceModificationTracker";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAttributes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTags";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSubTags";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTags";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceByPrefix";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "knownNamespaces";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getNsLocations";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHasNamespaceDeclarations";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalNamespaceDeclarations";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "addSubTag";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDtdDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNSVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultReferences";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 59: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "childContainsOffset";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePrefix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeNsDescriptorMap";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initializeSchema";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitNamespaceDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "retrieveFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "externalResourceModificationTracker";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findSubTags";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSubTag";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMap";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "computeNamespaceMap";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNsLocations";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addSubTag";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

