/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils;", "", "()V", "FILE_PATH_GROUP", "", "OFFSET_GROUP", "PSI_ELEMENT_COORDINATES", "Lkotlin/text/Regex;", "navigateTo", "", "requestLink", "", "parsePsiElementCoordinates", "Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils$Coordinates;", "rawCoordinates", "Coordinates", "intellij.platform.ide"})
public final class JBCefPsiNavigationUtils {
    @NonNls
    private static final Regex PSI_ELEMENT_COORDINATES;
    private static final int FILE_PATH_GROUP = 1;
    private static final int OFFSET_GROUP = 2;
    public static final JBCefPsiNavigationUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final boolean navigateTo(@NotNull String requestLink) {
        void filePath2;
        Intrinsics.checkNotNullParameter((Object)requestLink, (String)"requestLink");
        Coordinates coordinates = this.parsePsiElementCoordinates(requestLink);
        if (coordinates == null) {
            return false;
        }
        Coordinates coordinates2 = coordinates;
        String string = coordinates2.component1();
        int offset = coordinates2.component2();
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dataManager, (String)"DataManager.getInstance()");
        DataContext dataContext = dataManager.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance().dataContext");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"CommonDataKeys.PROJECT.g\u2026aContext) ?: return false");
        Project project2 = project;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Object[] objectArray = projectRootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectRootManager.getIn\u2026            .contentRoots");
        VirtualFile virtualFile2 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<VirtualFile, Path>((String)filePath2){
            final /* synthetic */ String $filePath;

            public final Path invoke(VirtualFile it) {
                VirtualFile virtualFile2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                return Paths.get(virtualFile2.getPath(), this.$filePath);
            }
            {
                this.$filePath = string;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Path, VirtualFile>(VirtualFileManager.getInstance()){

            @Nullable
            public final VirtualFile invoke(@NotNull Path p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((VirtualFileManager)this.receiver).findFileByNioPath(p1);
            }
        })));
        if (virtualFile2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ProjectRootManager.getIn\u2026tOrNull() ?: return false");
        VirtualFile virtualFile3 = virtualFile2;
        ApplicationManager.getApplication().invokeLater(new Runnable(project2, virtualFile3, offset){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ int $offset;

            public final void run() {
                FileEditorManager.getInstance(this.$project).openEditor(new OpenFileDescriptor(this.$project, this.$virtualFile, this.$offset), true);
            }
            {
                this.$project = project;
                this.$virtualFile = virtualFile2;
                this.$offset = n;
            }
        });
        return true;
    }

    private final Coordinates parsePsiElementCoordinates(String rawCoordinates) {
        MatchResult matchResult = PSI_ELEMENT_COORDINATES.matchEntire((CharSequence)rawCoordinates);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        Object object = groups.get(1);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object filePath2 = object;
        Object object2 = groups.get(2);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return null;
        }
        Object object3 = object2;
        boolean bl = false;
        int offset = Integer.parseInt((String)object3);
        return new Coordinates((String)filePath2, offset);
    }

    private JBCefPsiNavigationUtils() {
    }

    static {
        JBCefPsiNavigationUtils jBCefPsiNavigationUtils;
        INSTANCE = jBCefPsiNavigationUtils = new JBCefPsiNavigationUtils();
        String string = "source://(.+):(\\d+)";
        boolean bl = false;
        PSI_ELEMENT_COORDINATES = new Regex(string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils$Coordinates;", "", "filePath", "", "offset", "", "(Ljava/lang/String;I)V", "getFilePath", "()Ljava/lang/String;", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.ide"})
    private static final class Coordinates {
        @NotNull
        private final String filePath;
        private final int offset;

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getOffset() {
            return this.offset;
        }

        public Coordinates(@NotNull String filePath2, int offset) {
            Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
            this.filePath = filePath2;
            this.offset = offset;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final Coordinates copy(@NotNull String filePath2, int offset) {
            Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
            return new Coordinates(filePath2, offset);
        }

        public static /* synthetic */ Coordinates copy$default(Coordinates coordinates, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = coordinates.filePath;
            }
            if ((n2 & 2) != 0) {
                n = coordinates.offset;
            }
            return coordinates.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Coordinates(filePath=" + this.filePath + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            String string = this.filePath;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.offset);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Coordinates)) break block3;
                    Coordinates coordinates = (Coordinates)object;
                    if (!Intrinsics.areEqual((Object)this.filePath, (Object)coordinates.filePath) || this.offset != coordinates.offset) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

