/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.hover;

import com.intellij.openapi.util.Key;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.render.RenderingUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.swing.JList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class ListHoverListener
extends HoverListener {
    private final AtomicInteger indexHolder = new AtomicInteger(-1);
    private static final Key<Integer> HOVERED_INDEX_KEY = Key.create((String)"ListHoveredIndex");
    public static final HoverListener DEFAULT = new ListHoverListener(){

        @Override
        public void onHover(@NotNull JList<?> list, int index) {
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            1.setHoveredIndex(list, index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/hover/ListHoverListener$1", "onHover"));
        }
    };

    public abstract void onHover(@NotNull JList<?> var1, int var2);

    @Override
    public final void mouseEntered(@NotNull Component component, int x, int y) {
        if (component == null) {
            ListHoverListener.$$$reportNull$$$0(0);
        }
        this.mouseMoved(component, x, y);
    }

    @Override
    public final void mouseMoved(@NotNull Component component, int x, int y) {
        if (component == null) {
            ListHoverListener.$$$reportNull$$$0(1);
        }
        this.update(component, list -> list.locationToIndex(new Point(x, y)));
    }

    @Override
    public final void mouseExited(@NotNull Component component) {
        if (component == null) {
            ListHoverListener.$$$reportNull$$$0(2);
        }
        this.update(component, list -> -1);
    }

    private void update(@NotNull Component component, @NotNull ToIntFunction<JList<?>> indexFunc) {
        int indexOld;
        JList list;
        int indexNew;
        if (component == null) {
            ListHoverListener.$$$reportNull$$$0(3);
        }
        if (indexFunc == null) {
            ListHoverListener.$$$reportNull$$$0(4);
        }
        if (component instanceof JList && (indexNew = indexFunc.applyAsInt(list = (JList)component)) != (indexOld = this.indexHolder.getAndSet(indexNew))) {
            this.onHover(list, indexNew);
        }
    }

    @ApiStatus.Internal
    static void setHoveredIndex(@NotNull JList<?> list, int indexNew) {
        int indexOld;
        if (list == null) {
            ListHoverListener.$$$reportNull$$$0(5);
        }
        if (indexNew == (indexOld = ListHoverListener.getHoveredIndex(list))) {
            return;
        }
        list.putClientProperty(HOVERED_INDEX_KEY, indexNew < 0 ? null : Integer.valueOf(indexNew));
        if (RenderingUtil.isHoverPaintingDisabled(list)) {
            return;
        }
        ListHoverListener.repaintIndex(list, indexOld);
        ListHoverListener.repaintIndex(list, indexNew);
    }

    public static int getHoveredIndex(@NotNull JList<?> list) {
        Object property;
        if (list == null) {
            ListHoverListener.$$$reportNull$$$0(6);
        }
        return (property = list.getClientProperty(HOVERED_INDEX_KEY)) instanceof Integer ? (Integer)property : -1;
    }

    private static void repaintIndex(@NotNull JList<?> list, int index) {
        Rectangle bounds;
        if (list == null) {
            ListHoverListener.$$$reportNull$$$0(7);
        }
        Rectangle rectangle = bounds = index < 0 ? null : list.getCellBounds(index, index);
        if (bounds != null) {
            list.repaint(0, bounds.y, list.getWidth(), bounds.height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFunc";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/hover/ListHoverListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseEntered";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setHoveredIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getHoveredIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

