/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.DefaultProjectTypeEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ProjectType")
public class ProjectTypeService
implements PersistentStateComponent<ProjectType> {
    private ProjectType myProjectType;

    @Nullable
    public static ProjectType getProjectType(@Nullable Project project) {
        ProjectType projectType;
        if (project != null && (projectType = ProjectTypeService.getInstance((Project)project).myProjectType) != null) {
            return projectType;
        }
        return DefaultProjectTypeEP.getDefaultProjectType();
    }

    public static void setProjectType(@NotNull Project project, @NotNull ProjectType projectType) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(0);
        }
        if (projectType == null) {
            ProjectTypeService.$$$reportNull$$$0(1);
        }
        ProjectTypeService.getInstance(project).loadState(projectType);
    }

    private static ProjectTypeService getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(2);
        }
        return ServiceManager.getService(project, ProjectTypeService.class);
    }

    @Override
    @Nullable
    public ProjectType getState() {
        return this.myProjectType;
    }

    @Override
    public void loadState(@NotNull ProjectType state) {
        if (state == null) {
            ProjectTypeService.$$$reportNull$$$0(3);
        }
        this.myProjectType = state;
    }

    @TestOnly
    public static void clearFieldsForLightProjectInTests(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(4);
        }
        ProjectTypeService.getInstance((Project)project).myProjectType = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/ProjectTypeService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProjectType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearFieldsForLightProjectInTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

