/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ModuleUtil
extends ModuleUtilCore {
    private static final ParameterizedCachedValueProvider<MultiMap<ModuleType<?>, Module>, Project> MODULE_BY_TYPE_VALUE_PROVIDER = param -> {
        MultiMap map = new MultiMap();
        for (Module module : ModuleManager.getInstance(param).getModules()) {
            map.putValue(ModuleType.get(module), (Object)module);
        }
        return CachedValueProvider.Result.createSingleDependency(map, ProjectRootManager.getInstance(param));
    };
    private static final ParameterizedCachedValueProvider<Boolean, Project> HAS_TEST_ROOTS_PROVIDER = project -> {
        boolean hasTestRoots = Arrays.stream(ModuleManager.getInstance(project).getModules()).flatMap(module -> Arrays.stream(ModuleRootManager.getInstance(module).getContentEntries())).flatMap(entry -> Arrays.stream(entry.getSourceFolders())).anyMatch(folder -> folder.getRootType().isForTests());
        return CachedValueProvider.Result.createSingleDependency(hasTestRoots, ProjectRootManager.getInstance(project));
    };
    private static final Key<ParameterizedCachedValue<MultiMap<ModuleType<?>, Module>, Project>> MODULES_BY_TYPE_KEY = Key.create((String)"MODULES_BY_TYPE");
    private static final Key<ParameterizedCachedValue<Boolean, Project>> HAS_TEST_ROOTS_KEY = Key.create((String)"HAS_TEST_ROOTS");

    private ModuleUtil() {
    }

    @NotNull
    public static Collection<Module> getModulesOfType(@NotNull Project project, @NotNull ModuleType<?> moduleType) {
        if (project == null) {
            ModuleUtil.$$$reportNull$$$0(0);
        }
        if (moduleType == null) {
            ModuleUtil.$$$reportNull$$$0(1);
        }
        Collection collection = CachedValuesManager.getManager(project).getParameterizedCachedValue((UserDataHolder)project, MODULES_BY_TYPE_KEY, MODULE_BY_TYPE_VALUE_PROVIDER, false, project).get(moduleType);
        if (collection == null) {
            ModuleUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public static boolean hasModulesOfType(@NotNull Project project, @NotNull ModuleType<?> module) {
        if (project == null) {
            ModuleUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ModuleUtil.$$$reportNull$$$0(4);
        }
        return !ModuleUtil.getModulesOfType(project, module).isEmpty();
    }

    public static boolean hasTestSourceRoots(@NotNull Project project) {
        if (project == null) {
            ModuleUtil.$$$reportNull$$$0(5);
        }
        return CachedValuesManager.getManager(project).getParameterizedCachedValue((UserDataHolder)project, HAS_TEST_ROOTS_KEY, HAS_TEST_ROOTS_PROVIDER, false, project);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ModuleType<?> getModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleUtil.$$$reportNull$$$0(6);
        }
        return ModuleType.get(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/ModuleUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/ModuleUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModulesOfType";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasModulesOfType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasTestSourceRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

