/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageNamesValidation
extends LanguageExtension<NamesValidator> {
    public static final LanguageNamesValidation INSTANCE = new LanguageNamesValidation();

    private LanguageNamesValidation() {
        super("com.intellij.lang.namesValidator", new DefaultNamesValidator());
    }

    @Override
    @NotNull
    public NamesValidator forLanguage(@NotNull Language l) {
        if (l == null) {
            LanguageNamesValidation.$$$reportNull$$$0(0);
        }
        NamesValidator namesValidator = (NamesValidator)super.forLanguage(l);
        if (namesValidator == null) {
            LanguageNamesValidation.$$$reportNull$$$0(1);
        }
        return namesValidator;
    }

    public static boolean isIdentifier(@NotNull Language language, @NotNull String name) {
        if (language == null) {
            LanguageNamesValidation.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LanguageNamesValidation.$$$reportNull$$$0(3);
        }
        return LanguageNamesValidation.isIdentifier(language, name, null);
    }

    public static boolean isIdentifier(@NotNull Language language, @NotNull String name, @Nullable Project project) {
        if (language == null) {
            LanguageNamesValidation.$$$reportNull$$$0(4);
        }
        if (name == null) {
            LanguageNamesValidation.$$$reportNull$$$0(5);
        }
        return INSTANCE.forLanguage(language).isIdentifier(name, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/LanguageNamesValidation";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/LanguageNamesValidation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DefaultNamesValidator
    implements NamesValidator {
        protected DefaultNamesValidator() {
        }

        @Override
        public boolean isIdentifier(@NotNull String name, Project project) {
            int len;
            if (name == null) {
                DefaultNamesValidator.$$$reportNull$$$0(0);
            }
            if ((len = name.length()) == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < len; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isKeyword(@NotNull String name, Project project) {
            if (name == null) {
                DefaultNamesValidator.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/lang/LanguageNamesValidation$DefaultNamesValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isKeyword";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

