/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public final class ProjectGroup {
    @NotNull
    @NlsSafe
    private String myName;
    private String myProjectPaths;
    private List<String> myProjects;
    private boolean myExpanded;
    private boolean myTutorials;

    public ProjectGroup(@NotNull @NlsSafe String name) {
        if (name == null) {
            ProjectGroup.$$$reportNull$$$0(0);
        }
        this.myName = "";
        this.myProjects = new ArrayList<String>();
        this.myExpanded = false;
        this.myTutorials = false;
        this.myName = name;
    }

    public ProjectGroup() {
        this.myName = "";
        this.myProjects = new ArrayList<String>();
        this.myExpanded = false;
        this.myTutorials = false;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProjectGroup.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setName(@NotNull @NlsSafe String name) {
        if (name == null) {
            ProjectGroup.$$$reportNull$$$0(2);
        }
        this.myName = name;
    }

    public void setProjects(List<String> projects) {
        this.myProjects = projects;
    }

    public String getProjectPaths() {
        return null;
    }

    public void setProjectPaths(String projectPaths) {
        ArrayList<String> paths = new ArrayList<String>(StringUtil.split((String)projectPaths, (String)File.pathSeparator));
        paths.forEach(this::addProject);
    }

    public void addProject(@SystemIndependent String path2) {
        if (!this.myProjects.contains(path2)) {
            this.myProjects.add(path2);
        }
    }

    public boolean markProjectFirst(@SystemIndependent String path2) {
        if (!this.myProjects.contains(path2)) {
            return false;
        }
        ArrayList<String> existing = new ArrayList<String>(this.myProjects);
        int index = existing.indexOf(path2);
        if (index <= 0) {
            return false;
        }
        ArrayList<String> projects = new ArrayList<String>(existing.size());
        projects.add(path2);
        projects.addAll(existing.subList(0, index));
        projects.addAll(existing.subList(index + 1, existing.size()));
        this.save(projects);
        return true;
    }

    private void save(@NotNull List<String> projects) {
        if (projects == null) {
            ProjectGroup.$$$reportNull$$$0(3);
        }
        this.myProjects = projects;
    }

    @NotNull
    public List<String> getProjects() {
        List<String> list = this.myProjects;
        if (list == null) {
            ProjectGroup.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean removeProject(@SystemIndependent String path2) {
        return this.myProjects.remove(path2);
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isTutorials() {
        return this.myTutorials;
    }

    public void setTutorials(boolean tutorials) {
        this.myTutorials = tutorials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectGroup group = (ProjectGroup)o;
        return this.myName.equals(group.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ProjectGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ProjectGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

