/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.PopupListElementRendererWithIcon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.BranchFilters;
import com.intellij.vcs.log.ui.filter.BranchLogSpeedSearchPopup;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<BranchFilters, VcsLogClassicFilterUi.BranchFilterModel> {
    private final VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        if (uiProperties == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(0);
        }
        if (filterModel == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(1);
        }
        super("Branch", VcsLogBundle.messagePointer((String)"vcs.log.branch.filter.label", (Object[])new Object[0]), uiProperties, filterModel);
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull BranchFilters filters) {
        if (filters == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(2);
        }
        List<String> list = VcsLogClassicFilterUi.BranchFilterModel.getFilterPresentation(filters);
        if (list == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    protected BranchFilters createFilter(@NotNull List<String> values) {
        if (values == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(4);
        }
        return ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).createFilterFromPresentation(values);
    }

    @Override
    @NotNull
    protected MultilinePopupBuilder.CompletionPrefixProvider getCompletionPrefixProvider() {
        MultilinePopupBuilder.CompletionPrefixProvider completionPrefixProvider = (text2, offset) -> {
            int index = 0;
            for (String s : BranchFilterPopupComponent.getCompletionSeparators()) {
                int separatorIndex = text2.lastIndexOf(s, offset - s.length());
                if (separatorIndex <= index) continue;
                index = separatorIndex + s.length();
            }
            String prefix = text2.substring(index, offset);
            return StringUtil.trimLeading((String)prefix, (char)'-');
        };
        if (completionPrefixProvider == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(5);
        }
        return completionPrefixProvider;
    }

    @Override
    @NotNull
    protected List<String> parseLocalizedValues(@NotNull Collection<String> values) {
        if (values == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(6);
        }
        return new ArrayList<String>(values);
    }

    @Override
    @NotNull
    protected List<String> getLocalizedValues(@NotNull Collection<String> values) {
        if (values == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(7);
        }
        return new ArrayList<String>(values);
    }

    @NotNull
    private static List<String> getCompletionSeparators() {
        ArrayList<String> separators = new ArrayList<String>();
        for (char c : MultilinePopupBuilder.SEPARATORS) {
            separators.add(String.valueOf(c));
        }
        separators.add("..");
        ArrayList<String> arrayList = separators;
        if (arrayList == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        return new MyBranchLogSpeedSearchPopup();
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        VcsLogDataPack logData = ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack();
        List<List<String>> branchFilters = BranchFilterPopupComponent.processRecentBranchFilters(ContainerUtil.map2Set((Collection)logData.getRefs().getBranches(), VcsRef::getName), this.getRecentValuesFromSettings());
        actionGroup.add((AnAction)new MyBranchPopupBuilder(logData, this.myBranchFilterModel.getVisibleRoots(), branchFilters).build());
        return actionGroup;
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        Collection branches = ((VcsLogClassicFilterUi.BranchFilterModel)this.myFilterModel).getDataPack().getRefs().getBranches();
        if (this.myBranchFilterModel.getVisibleRoots() != null) {
            branches = ContainerUtil.filter((Collection)branches, branch -> this.myBranchFilterModel.getVisibleRoots().contains(branch.getRoot()));
        }
        List list = ContainerUtil.map((Collection)branches, VcsRef::getName);
        if (list == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<List<String>> processRecentBranchFilters(@NotNull Set<String> availableBranches, @NotNull List<List<String>> recentBranchFilters) {
        if (availableBranches == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(10);
        }
        if (recentBranchFilters == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(11);
        }
        if (availableBranches.isEmpty()) {
            List<List<String>> list = recentBranchFilters;
            if (list == null) {
                BranchFilterPopupComponent.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ContainerUtil.filter(recentBranchFilters, recentFilter -> !VcsLogFilterObject.fromBranchPatterns(recentFilter, availableBranches, true).isEmpty());
        if (list == null) {
            BranchFilterPopupComponent.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableBranches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentBranchFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPrefixProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionSeparators";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processRecentBranchFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilterValues";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseLocalizedValues";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalizedValues";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processRecentBranchFilters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyBranchLogSpeedSearchPopup
    extends BranchLogSpeedSearchPopup {
        private PopupListElementRendererWithIcon myListElementRenderer;

        MyBranchLogSpeedSearchPopup() {
            super(BranchFilterPopupComponent.this.createActionGroup(), DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this));
        }

        protected MyBranchLogSpeedSearchPopup(@NotNull WizardPopup parent, @Nullable ListPopupStep step2, Object value) {
            if (step2 == null) {
                MyBranchLogSpeedSearchPopup.$$$reportNull$$$0(0);
            }
            super(parent, step2, DataManager.getInstance().getDataContext((Component)BranchFilterPopupComponent.this), value);
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            MyBranchPopupBuilder.BranchFilterAction branchAction = MyBranchLogSpeedSearchPopup.getSpecificAction(this.getList().getSelectedValue(), MyBranchPopupBuilder.BranchFilterAction.class);
            if (branchAction != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
                branchAction.toggle();
                this.getList().repaint();
            } else {
                super.handleSelect(handleFinalChoices, e);
            }
        }

        protected PopupListElementRendererWithIcon getListElementRenderer() {
            if (this.myListElementRenderer == null) {
                this.myListElementRenderer = new PopupListElementRendererWithIcon((ListPopupImpl)this);
            }
            return this.myListElementRenderer;
        }

        protected WizardPopup createPopup(WizardPopup parent, PopupStep step2, Object parentValue) {
            if (step2 instanceof ListPopupStep) {
                return new MyBranchLogSpeedSearchPopup(parent, (ListPopupStep)step2, parentValue);
            }
            return super.createPopup(parent, step2, parentValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchLogSpeedSearchPopup", "<init>"));
        }
    }

    private class MyBranchPopupBuilder
    extends BranchPopupBuilder {
        protected MyBranchPopupBuilder(@Nullable VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, List<? extends List<String>> recentItems) {
            if (dataPack == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(0);
            }
            super(dataPack, visibleRoots, recentItems);
        }

        @Override
        @NotNull
        public AnAction createAction(@NotNull String name, @NotNull Collection<? extends VcsRef> refs) {
            if (name == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(1);
            }
            if (refs == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(2);
            }
            return new BranchFilterAction(() -> name, refs);
        }

        @Override
        protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItems) {
            if (actionGroup == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(3);
            }
            if (recentItems == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(4);
            }
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, recentItems));
        }

        @Override
        @NotNull
        protected AnAction createCollapsedAction(@NotNull String actionName, @NotNull Collection<? extends VcsRef> refs) {
            if (actionName == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(5);
            }
            if (refs == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(6);
            }
            return new BranchFilterAction(() -> actionName, refs);
        }

        @Override
        protected void createFavoritesAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> favorites) {
            if (actionGroup == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(7);
            }
            if (favorites == null) {
                MyBranchPopupBuilder.$$$reportNull$$$0(8);
            }
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, favorites, VcsLogBundle.messagePointer((String)"vcs.log.branch.filter.favorites", (Object[])new Object[0]), false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recentItems";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "favorites";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRecentAction";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCollapsedAction";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFavoritesAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class BranchFilterAction
        extends MultipleValueFilterPopupComponent.PredefinedValueAction {
            @NotNull
            private final LayeredIcon myIcon;
            @NotNull
            private final LayeredIcon myHoveredIcon;
            @NotNull
            private final Collection<? extends VcsRef> myReferences;
            private boolean myIsFavorite;

            BranchFilterAction(@NotNull Supplier<String> displayName, Collection<? extends VcsRef> references) {
                if (displayName == null) {
                    BranchFilterAction.$$$reportNull$$$0(0);
                }
                if (references == null) {
                    BranchFilterAction.$$$reportNull$$$0(1);
                }
                super(BranchFilterPopupComponent.this, new ArrayList<String>(ContainerUtil.map2LinkedSet(references, ref -> ref.getName())), displayName, true);
                this.myReferences = references;
                this.myIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, EmptyIcon.ICON_16});
                this.myHoveredIcon = new LayeredIcon(new Icon[]{AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover});
                this.getTemplatePresentation().setIcon((Icon)this.myIcon);
                this.getTemplatePresentation().setSelectedIcon((Icon)this.myHoveredIcon);
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            private boolean isFavorite() {
                for (VcsRef vcsRef : this.myReferences) {
                    if (!((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().isFavorite(vcsRef)) continue;
                    return true;
                }
                return false;
            }

            private void updateIcons() {
                this.myIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(0, this.myIsFavorite);
                this.myIcon.setLayerEnabled(1, !this.myIsFavorite);
                this.myHoveredIcon.setLayerEnabled(1, !this.myIsFavorite);
            }

            public void setFavorite(boolean favorite) {
                for (VcsRef vcsRef : this.myReferences) {
                    ((VcsLogProvider)MyBranchPopupBuilder.this.myDataPack.getLogProviders().get(vcsRef.getRoot())).getReferenceManager().setFavorite(vcsRef, favorite);
                }
                this.myIsFavorite = this.isFavorite();
                this.updateIcons();
            }

            public void toggle() {
                this.setFavorite(!this.myIsFavorite);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "displayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "references";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder$BranchFilterAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

