/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogEditorUtilKt;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.editor.DefaultVcsLogFile;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsManager {
    private static final Logger LOG = Logger.getInstance(VcsLogTabsManager.class);
    private static final TabGroupId TAB_GROUP_ID = new TabGroupId("Log", () -> VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), true);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogProjectTabsProperties myUiProperties;
    private boolean myIsLogDisposing;

    VcsLogTabsManager(final @NotNull Project project, @NotNull MessageBus messageBus, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            VcsLogTabsManager.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogTabsManager.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogTabsManager.$$$reportNull$$$0(3);
        }
        this.myIsLogDisposing = false;
        this.myProject = project;
        this.myUiProperties = uiProperties;
        messageBus.connect(parent).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogTabsManager.this.myIsLogDisposing = false;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.assertTrue(!Disposer.isDisposed((Disposable)manager), (Object)"Attempting to open tabs on disposed VcsLogManager")) {
                        VcsLogTabsManager.this.createLogTabs(manager);
                    }
                }, ModalityState.NON_MODAL, o -> manager != VcsProjectLog.getInstance(project).getLogManager());
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                if (manager == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogTabsManager.this.myIsLogDisposing = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "manager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @RequiresEdt
    private void createLogTabs(@NotNull VcsLogManager manager) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(4);
        }
        this.myUiProperties.getTabs().forEach((id, kind) -> this.openLogTab(manager, (String)id, (VcsLogManager.LogWindowKind)((Object)kind), false, null));
    }

    @NotNull
    public Collection<String> getTabs() {
        Set<String> set = this.myUiProperties.getTabs().keySet();
        if (set == null) {
            VcsLogTabsManager.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    MainVcsLogUi openAnotherLogTab(@NotNull VcsLogManager manager, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(6);
        }
        if (kind == null) {
            VcsLogTabsManager.$$$reportNull$$$0(7);
        }
        return this.openLogTab(manager, VcsLogTabsManager.generateTabId(this.myProject), kind, true, filters);
    }

    @NotNull
    private MainVcsLogUi openLogTab(@NotNull VcsLogManager manager, @NotNull String tabId, @NotNull VcsLogManager.LogWindowKind kind, boolean focus, @Nullable VcsLogFilterCollection filters) {
        MainVcsLogUi ui2;
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(8);
        }
        if (tabId == null) {
            VcsLogTabsManager.$$$reportNull$$$0(9);
        }
        if (kind == null) {
            VcsLogTabsManager.$$$reportNull$$$0(10);
        }
        if (filters != null) {
            this.myUiProperties.resetState(tabId);
        }
        PersistentVcsLogUiFactory factory = new PersistentVcsLogUiFactory(manager.getMainLogUiFactory(tabId, filters), kind);
        if (kind == VcsLogManager.LogWindowKind.EDITOR) {
            ui2 = VcsLogTabsManager.openLogEditorTab(this.myProject, manager, VcsLogTabsManager.getFullName(tabId), factory, focus);
            ui2.getFilterUi().addFilterListener(() -> VcsLogEditorUtilKt.updateTabName(this.myProject, ui2));
        } else if (kind == VcsLogManager.LogWindowKind.TOOL_WINDOW) {
            ui2 = VcsLogContentUtil.openLogTab(this.myProject, manager, TAB_GROUP_ID, u -> VcsLogTabsManager.generateShortDisplayName(u), factory, focus);
            ui2.getFilterUi().addFilterListener(() -> VcsLogContentUtil.updateLogUiName(this.myProject, ui2));
        } else {
            throw new UnsupportedOperationException("Only log in editor or tool window is supported");
        }
        MainVcsLogUi mainVcsLogUi = ui2;
        if (mainVcsLogUi == null) {
            VcsLogTabsManager.$$$reportNull$$$0(11);
        }
        return mainVcsLogUi;
    }

    @NotNull
    private static MainVcsLogUi openLogEditorTab(@NotNull Project project, @NotNull VcsLogManager manager, @NotNull String fileName, @NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory, boolean focus) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            VcsLogTabsManager.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            VcsLogTabsManager.$$$reportNull$$$0(14);
        }
        if (factory == null) {
            VcsLogTabsManager.$$$reportNull$$$0(15);
        }
        MainVcsLogUi ui2 = manager.createLogUi(factory, VcsLogManager.LogWindowKind.EDITOR);
        DefaultVcsLogFile file = new DefaultVcsLogFile(fileName, new VcsLogPanel(manager, ui2));
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, focus);
        manager.scheduleInitialization();
        MainVcsLogUi mainVcsLogUi = ui2;
        if (mainVcsLogUi == null) {
            VcsLogTabsManager.$$$reportNull$$$0(16);
        }
        return mainVcsLogUi;
    }

    @NotNull
    @NlsContexts.TabTitle
    private static String generateShortDisplayName(@NotNull VcsLogUi ui2) {
        VcsLogFilterCollection filters;
        if (ui2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(17);
        }
        if ((filters = ui2.getFilterUi().getFilters()).isEmpty()) {
            return "";
        }
        String string = StringUtil.shortenTextWithEllipsis((String)VcsLogFiltersKt.getPresentation(filters), (int)150, (int)20);
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    @NlsContexts.TabTitle
    private static String getFullName(@NotNull @NlsContexts.TabTitle String shortName) {
        if (shortName == null) {
            VcsLogTabsManager.$$$reportNull$$$0(19);
        }
        String string = ContentUtilEx.getFullName((String)VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]), (String)shortName);
        if (string == null) {
            VcsLogTabsManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    @NlsContexts.TabTitle
    public static String generateDisplayName(@NotNull VcsLogUi ui2) {
        if (ui2 == null) {
            VcsLogTabsManager.$$$reportNull$$$0(21);
        }
        return VcsLogTabsManager.getFullName(VcsLogTabsManager.generateShortDisplayName(ui2));
    }

    @NotNull
    @NonNls
    private static String generateTabId(@NotNull Project project) {
        if (project == null) {
            VcsLogTabsManager.$$$reportNull$$$0(22);
        }
        Set existingIds = ContainerUtil.union(VcsLogContentUtil.getExistingLogIds(project), VcsLogEditorUtilKt.getExistingLogIds(project));
        int i = 1;
        while (true) {
            String idString;
            if (!existingIds.contains(idString = Integer.toString(i))) {
                String string = idString;
                if (string == null) {
                    VcsLogTabsManager.$$$reportNull$$$0(23);
                }
                return string;
            }
            ++i;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "openLogTab";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "openLogEditorTab";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateShortDisplayName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTabId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLogTabs";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openAnotherLogTab";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "openLogEditorTab";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateShortDisplayName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateDisplayName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateTabId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PersistentVcsLogUiFactory
    implements VcsLogManager.VcsLogUiFactory<MainVcsLogUi> {
        @NotNull
        private final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> myFactory;
        @NotNull
        private final VcsLogManager.LogWindowKind myLogWindowKind;

        PersistentVcsLogUiFactory(@NotNull VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> factory, VcsLogManager.LogWindowKind kind) {
            if (factory == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            this.myFactory = factory;
            this.myLogWindowKind = kind;
        }

        @Override
        public MainVcsLogUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            if (logData == null) {
                PersistentVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            MainVcsLogUi ui2 = this.myFactory.createLogUi(project, logData);
            VcsLogTabsManager.this.myUiProperties.addTab(ui2.getId(), this.myLogWindowKind);
            Disposer.register((Disposable)ui2, () -> {
                if (VcsLogTabsManager.this.myProject.isDisposed() || VcsLogTabsManager.this.myIsLogDisposing) {
                    return;
                }
                VcsLogTabsManager.this.myUiProperties.removeTab(ui2.getId());
            });
            return ui2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogTabsManager$PersistentVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

