/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryColorManager;", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "baseColorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManagerImpl;", "getLongName", "", "getPathColor", "Ljava/awt/Color;", "getPaths", "", "update", "", "pack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryColorManager
implements VcsLogColorManager {
    private VcsLogColorManagerImpl baseColorManager;
    private final VirtualFile root;
    private final FilePath path;

    @Override
    @NotNull
    public Color getPathColor(@NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Color color = this.baseColorManager.getPathColor(path2);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"baseColorManager.getPathColor(path)");
        return color;
    }

    public final void update(@NotNull VcsLogDataPack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        Set<FilePath> pathsFromPack = FileHistoryPaths.filePaths(pack);
        if (pathsFromPack.isEmpty()) {
            this.baseColorManager = new VcsLogColorManagerImpl(SetsKt.setOf((Object)this.path));
        } else {
            ObjectLinkedOpenCustomHashSet newPaths = new ObjectLinkedOpenCustomHashSet(this.baseColorManager.getPaths(), FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
            newPaths.retainAll((Collection)pathsFromPack);
            newPaths.addAll((Collection)pathsFromPack);
            this.baseColorManager = new VcsLogColorManagerImpl((Collection)newPaths);
        }
    }

    @Override
    @NotNull
    public Collection<FilePath> getPaths() {
        Collection<FilePath> collection = this.baseColorManager.getPaths();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"baseColorManager.paths");
        return collection;
    }

    @Override
    @NotNull
    public String getLongName(@NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string = VcsFileUtil.relativePath(this.root, path2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsFileUtil.relativePath(root, path)");
        return string;
    }

    public FileHistoryColorManager(@NotNull VirtualFile root, @NotNull FilePath path2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.root = root;
        this.path = path2;
        this.baseColorManager = new VcsLogColorManagerImpl(SetsKt.setOf((Object)this.path));
    }
}

