/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware {
    public AnnotateRevisionAction() {
        super(VcsBundle.messagePointer((String)"annotate.action.name", (Object[])new Object[0]), VcsBundle.messagePointer((String)"annotate.action.description", (Object[])new Object[0]), AllIcons.Actions.Annotate);
        this.setShortcutSet(ActionManager.getInstance().getAction("Annotate").getShortcutSet());
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        VirtualFile editorFile;
        Project project;
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null) {
            return null;
        }
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && Comparing.equal((Object)(editorFile = FileDocumentManager.getInstance().getFile(editor.getDocument())), (Object)virtualFile)) {
            return editor;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
        if (fileEditor instanceof TextEditor) {
            return ((TextEditor)fileEditor).getEditor();
        }
        return null;
    }

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(1);
        }
        return VcsUtil.findVcs((AnActionEvent)e);
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        Boolean nonLocal;
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(2);
        }
        if (Boolean.TRUE.equals(nonLocal = (Boolean)e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION))) {
            return null;
        }
        VirtualFile file = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (file == null || file.isDirectory()) {
            return null;
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null || filePath.getFileType().isBinary()) {
            return null;
        }
        return file;
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        VcsHistorySession historySession;
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(3);
        }
        if ((historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION)) == null) {
            return null;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (!historySession.isContentAvailable(revision)) {
            return null;
        }
        return revision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/history/actions/AnnotateRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

