/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u00a8\u0006\f"}, d2={"askReviewCommitCancel", "", "worker", "Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;", "commitActionText", "", "confirmCommitInDumbMode", "", "project", "Lcom/intellij/openapi/project/Project;", "confirmCommitWithSkippedFiles", "getDescription", "intellij.platform.vcs.impl"})
public final class TodoCheckinHandlerKt {
    private static final boolean confirmCommitInDumbMode(Project project) {
        String string = VcsBundle.message((String)"checkin.dialog.title.not.possible.right.now", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkin.dialog.\u2026.not.possible.right.now\")");
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[0] = applicationNamesInfo.getFullProductName();
        String string2 = VcsBundle.message((String)"checkin.dialog.message.cant.be.performed", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"checkin.dialog.\u2026stance().fullProductName)");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(null);
        String string3 = VcsBundle.message((String)"checkin.wait", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"checkin.wait\")");
        MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
        String string4 = VcsBundle.message((String)"checkin.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"checkin.commit\")");
        return !((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).ask(project);
    }

    private static final boolean confirmCommitWithSkippedFiles(TodoCheckinHandlerWorker worker, @NlsContexts.Button String commitActionText) {
        String string = VcsBundle.message((String)"checkin.dialog.title.todo", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkin.dialog.title.todo\")");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, TodoCheckinHandlerKt.getDescription(worker)).icon(UIUtil.getWarningIcon())).yesText(commitActionText);
        String string2 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCancelButtonText()");
        return ((MessageDialogBuilder.YesNo)yesNo.noText(string2)).ask(worker.getProject());
    }

    @Messages.YesNoCancelResult
    private static final int askReviewCommitCancel(TodoCheckinHandlerWorker worker, @NlsContexts.Button String commitActionText) {
        String string = VcsBundle.message((String)"checkin.dialog.title.todo", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"checkin.dialog.title.todo\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel = (MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(string, TodoCheckinHandlerKt.getDescription(worker)).icon(UIUtil.getWarningIcon());
        String string2 = VcsBundle.message((String)"todo.in.new.review.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"todo.in.new.review.button\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string2)).noText(commitActionText);
        String string3 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText()");
        return yesNoCancel2.cancelText(string3).show(worker.getProject());
    }

    @NlsContexts.DialogMessage
    private static final String getDescription(TodoCheckinHandlerWorker worker) {
        String string;
        int added = worker.getAddedOrEditedTodos().size();
        int changed = worker.getInChangedTodos().size();
        int skipped = worker.getSkipped().size();
        if (added == 0 && changed == 0) {
            String string2 = VcsBundle.message((String)"todo.handler.only.skipped", (Object[])new Object[]{skipped});
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"todo.handler.only.skipped\", skipped)");
        } else if (changed == 0) {
            String string3 = VcsBundle.message((String)"todo.handler.only.added", (Object[])new Object[]{added, skipped});
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"todo.handler.only.added\", added, skipped)");
        } else if (added == 0) {
            String string4 = VcsBundle.message((String)"todo.handler.only.in.changed", (Object[])new Object[]{changed, skipped});
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"todo.handler.on\u2026anged\", changed, skipped)");
        } else {
            String string5 = VcsBundle.message((String)"todo.handler.only.both", (Object[])new Object[]{added, changed, skipped});
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"todo.handler.on\u2026 added, changed, skipped)");
        }
        return string;
    }

    public static final /* synthetic */ boolean access$confirmCommitInDumbMode(Project project) {
        return TodoCheckinHandlerKt.confirmCommitInDumbMode(project);
    }

    public static final /* synthetic */ boolean access$confirmCommitWithSkippedFiles(TodoCheckinHandlerWorker worker, String commitActionText) {
        return TodoCheckinHandlerKt.confirmCommitWithSkippedFiles(worker, commitActionText);
    }

    public static final /* synthetic */ int access$askReviewCommitCancel(TodoCheckinHandlerWorker worker, String commitActionText) {
        return TodoCheckinHandlerKt.askReviewCommitCancel(worker, commitActionText);
    }
}

