/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.BindableConfigurable;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangelistConflictConfigurable
extends BindableConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    @BindControl(value="SHOW_DIALOG")
    private JCheckBox myShowDialogCheckBox;
    @BindControl(value="HIGHLIGHT_CONFLICTS")
    private JCheckBox myHighlightConflictsCheckBox;
    @BindControl(value="HIGHLIGHT_NON_ACTIVE_CHANGELIST")
    private JCheckBox myHighlightNonActiveCheckBox;
    private JBList myIgnoredFiles;
    private JButton myClearButton;
    private JCheckBox myEnablePartialChangelists;
    private JPanel myIgnoredFilesPanel;
    private boolean myIgnoredFilesCleared;
    private final ChangelistConflictTracker myConflictTracker;
    private final VcsApplicationSettings myVcsApplicationSettings;
    @Nullable
    private Disposable myDisposable;

    public ChangelistConflictConfigurable(Project project) {
        this(ChangelistConflictTracker.getInstance(project));
    }

    public ChangelistConflictConfigurable(ChangelistConflictTracker conflictTracker) {
        super(new ControlBinder((Object)conflictTracker.getOptions()));
        this.$$$setupUI$$$();
        this.myVcsApplicationSettings = VcsApplicationSettings.getInstance();
        this.myConflictTracker = conflictTracker;
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangelistConflictConfigurable.this.myIgnoredFiles.setModel(new DefaultListModel());
                ChangelistConflictConfigurable.this.myIgnoredFilesCleared = true;
                ChangelistConflictConfigurable.this.myClearButton.setEnabled(false);
            }
        });
        this.myIgnoredFilesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)VcsBundle.message((String)"settings.files.with.ignored.conflicts.list.title", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myIgnoredFiles.getEmptyText().setText(VcsBundle.message((String)"no.ignored.files", (Object[])new Object[0]));
    }

    public JComponent createComponent() {
        this.getBinder().bindAnnotations((Object)this);
        SwingUtilities.updateComponentTreeUI(this.myPanel);
        this.myDisposable = Disposer.newDisposable((String)"Changelist Conflict Configurable");
        ChangeListUtil.onChangeListAvailabilityChanged(this.myConflictTracker.getProject(), this.myDisposable, true, () -> UIUtil.setEnabled((Component)this.myPanel, (boolean)ChangeListManager.getInstance((Project)this.myConflictTracker.getProject()).areChangeListsEnabled(), (boolean)true));
        return this.myPanel;
    }

    public void reset() {
        super.reset();
        this.myEnablePartialChangelists.setSelected(this.myVcsApplicationSettings.ENABLE_PARTIAL_CHANGELISTS);
        Collection<String> conflicts = this.myConflictTracker.getIgnoredConflicts();
        this.myIgnoredFiles.setListData((Object[])ArrayUtilRt.toStringArray(conflicts));
        this.myClearButton.setEnabled(!conflicts.isEmpty());
    }

    public void apply() throws ConfigurationException {
        super.apply();
        if (this.myIgnoredFilesCleared) {
            for (ChangelistConflictTracker.Conflict conflict : this.myConflictTracker.getConflicts().values()) {
                conflict.ignored = false;
            }
        }
        if (this.myEnablePartialChangelists.isSelected() != this.myVcsApplicationSettings.ENABLE_PARTIAL_CHANGELISTS) {
            this.myVcsApplicationSettings.ENABLE_PARTIAL_CHANGELISTS = this.myEnablePartialChangelists.isSelected();
            ((LineStatusTrackerSettingListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LineStatusTrackerSettingListener.TOPIC)).settingsUpdated();
        }
        this.myConflictTracker.optionsChanged();
    }

    public boolean isModified() {
        return super.isModified() || this.myIgnoredFiles.getModel().getSize() != this.myConflictTracker.getIgnoredConflicts().size() || this.myEnablePartialChangelists.isSelected() != this.myVcsApplicationSettings.ENABLE_PARTIAL_CHANGELISTS;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"configurable.ChangelistConflictConfigurable.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.ChangelistConflict";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            ChangelistConflictConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void disposeUIResources() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        this.myDisposable = null;
        super.disposeUIResources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictConfigurable", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBList jBList;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEnablePartialChangelists = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/VcsBundle", ChangelistConflictConfigurable.class).getString("settings.partial.changelists.enable.checkbox"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowDialogCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/VcsBundle", ChangelistConflictConfigurable.class).getString("settings.show.conflict.resolve.dialog.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHighlightConflictsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/VcsBundle", ChangelistConflictConfigurable.class).getString("settings.highlight.files.with.conflicts.checkbox"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHighlightNonActiveCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/VcsBundle", ChangelistConflictConfigurable.class).getString("settings.highlight.files.from.non.active.changelist.checkbox"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoredFilesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myIgnoredFiles = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myClearButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/VcsBundle", ChangelistConflictConfigurable.class).getString("button.clear"));
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

