/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.FilesProcessorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u0015H\u0004J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0016\u0010\u001a\u001a\u00020\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H&J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H&J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0004J\b\u0010 \u001a\u00020\u001dH\u0014J\b\u0010!\u001a\u00020\u001dH\u0004J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\b\u0010#\u001a\u00020\u0015H&J\b\u0010$\u001a\u00020\u0015H\u0014J\u0016\u0010%\u001a\u00020\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0004J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u001dH\u0004J\b\u0010)\u001a\u00020\u001dH\u0004R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/FilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "askedBeforeProperty", "", "getAskedBeforeProperty", "()Ljava/lang/String;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "acquireValidFiles", "", "addNewFiles", "", "filesToAdd", "", "clearFiles", "dispose", "doActionOnChosenFiles", "doFilterFiles", "doProcess", "", "getForCurrentProject", "isFilesEmpty", "needDoForCurrentProject", "notAskedBefore", "processFiles", "rememberForAllProjects", "rememberForCurrentProject", "removeFiles", "filesToRemove", "setForCurrentProject", "value", "wasAskedBefore", "intellij.platform.vcs.impl"})
public abstract class FilesProcessorImpl
implements FilesProcessor {
    private final Set<VirtualFile> files;
    @NotNull
    private final Project project;

    @NotNull
    public abstract String getAskedBeforeProperty();

    @Nullable
    public abstract String getDoForCurrentProjectProperty();

    public abstract void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> var1);

    @NotNull
    public abstract Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> var1);

    public abstract void rememberForAllProjects();

    protected void rememberForCurrentProject() {
        this.setForCurrentProject(true);
    }

    @NotNull
    public List<VirtualFile> processFiles(@NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection<VirtualFile> filteredFiles = this.doFilterFiles((Collection<? extends VirtualFile>)files);
        if (filteredFiles.isEmpty()) {
            return files;
        }
        this.addNewFiles(filteredFiles);
        this.doProcess();
        return CollectionsKt.minus((Iterable)files, (Iterable)filteredFiles);
    }

    protected boolean doProcess() {
        boolean doForCurrentProject = this.needDoForCurrentProject();
        if (doForCurrentProject) {
            this.doActionOnChosenFiles((Collection<? extends VirtualFile>)this.acquireValidFiles());
            this.clearFiles();
        }
        return doForCurrentProject;
    }

    protected final synchronized boolean removeFiles(@NotNull Collection<? extends VirtualFile> filesToRemove2) {
        Intrinsics.checkNotNullParameter(filesToRemove2, (String)"filesToRemove");
        return this.files.removeAll(filesToRemove2);
    }

    protected final synchronized boolean isFilesEmpty() {
        return this.files.isEmpty();
    }

    protected final synchronized void addNewFiles(@NotNull Collection<? extends VirtualFile> filesToAdd) {
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        this.files.addAll(filesToAdd);
    }

    @NotNull
    protected final synchronized List<VirtualFile> acquireValidFiles() {
        CollectionsKt.removeAll((Iterable)this.files, (Function1)acquireValidFiles.1.INSTANCE);
        return CollectionsKt.toList((Iterable)this.files);
    }

    protected final synchronized void clearFiles() {
        this.files.clear();
    }

    public void dispose() {
        this.clearFiles();
    }

    protected final void setForCurrentProject(boolean value) {
        block0: {
            String string = this.getDoForCurrentProjectProperty();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            PropertiesComponent.getInstance((Project)this.project).setValue(it, value);
        }
    }

    private final boolean getForCurrentProject() {
        boolean bl;
        String string = this.getDoForCurrentProjectProperty();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            bl = PropertiesComponent.getInstance((Project)this.project).getBoolean(it, false);
        } else {
            bl = false;
        }
        return bl;
    }

    protected final boolean notAskedBefore() {
        return !this.wasAskedBefore();
    }

    protected final boolean wasAskedBefore() {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(this.getAskedBeforeProperty(), false);
    }

    protected boolean needDoForCurrentProject() {
        return this.getForCurrentProject();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public FilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        boolean bl = false;
        this.files = new LinkedHashSet();
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
    }
}

