/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.GitPatchWriter;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.project.ProjectKt;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnifiedDiffWriter {
    @NonNls
    private static final String INDEX_SIGNATURE = "Index: {0}{1}";
    @NonNls
    public static final String ADDITIONAL_PREFIX = "IDEA additional info:";
    @NonNls
    public static final String ADD_INFO_HEADER = "Subsystem: ";
    @NonNls
    public static final String ADD_INFO_LINE_START = "<+>";
    private static final String HEADER_SEPARATOR = "===================================================================";
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";
    @NonNls
    public static final String DEV_NULL = "/dev/null";
    @NonNls
    public static final String A_PREFIX = "a/";
    @NonNls
    public static final String B_PREFIX = "b/";

    private UnifiedDiffWriter() {
    }

    public static void write(@Nullable Project project, @NotNull Collection<? extends FilePatch> patches, @NotNull Writer writer, @NotNull String lineSeparator, @Nullable CommitContext commitContext) throws IOException {
        if (patches == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(1);
        }
        if (lineSeparator == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(2);
        }
        UnifiedDiffWriter.write(project, project == null ? null : ProjectKt.getStateStore((Project)project).getProjectBasePath(), patches, writer, lineSeparator, commitContext, null);
    }

    public static void write(@Nullable Project project, @Nullable Path basePath, @NotNull Collection<? extends FilePatch> patches, @NotNull Writer writer, @NotNull String lineSeparator, @Nullable CommitContext commitContext, @Nullable List<PatchEP> patchEpExtensions) throws IOException {
        if (patches == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(4);
        }
        if (lineSeparator == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(5);
        }
        ArrayList<TextFilePatch> noContentPatches = new ArrayList<TextFilePatch>();
        for (FilePatch filePatch : patches) {
            if (!(filePatch instanceof TextFilePatch)) continue;
            TextFilePatch patch = (TextFilePatch)filePatch;
            if (patch.hasNoModifiedContent()) {
                noContentPatches.add(patch);
                continue;
            }
            String path2 = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
            String pathRelatedToProjectDir = UnifiedDiffWriter.getPathRelatedToProjectDir(project, basePath, path2);
            HashMap<String, CharSequence> additionalMap = new HashMap<String, CharSequence>();
            if (project != null) {
                for (PatchEP extension : patchEpExtensions == null ? PatchEP.EP_NAME.getExtensionList() : patchEpExtensions) {
                    CharSequence charSequence = extension.provideContent(project, pathRelatedToProjectDir, commitContext);
                    if (StringUtil.isEmpty((CharSequence)charSequence)) continue;
                    additionalMap.put(extension.getName(), charSequence);
                }
            }
            String fileContentLineSeparator = PatchWriter.shouldUseDefaultSeparator(project) ? "\n" : (String)ObjectUtils.coalesce((Object)patch.getLineSeparator(), (Object)lineSeparator, (Object)"\n");
            UnifiedDiffWriter.writeFileHeading(writer, basePath, (FilePatch)patch, lineSeparator, additionalMap);
            for (PatchHunk hunk : patch.getHunks()) {
                UnifiedDiffWriter.writeHunkStart(writer, hunk.getStartLineBefore(), hunk.getEndLineBefore(), hunk.getStartLineAfter(), hunk.getEndLineAfter(), lineSeparator);
                for (PatchLine line : hunk.getLines()) {
                    char prefixChar = ' ';
                    switch (line.getType()) {
                        case ADD: {
                            prefixChar = '+';
                            break;
                        }
                        case REMOVE: {
                            prefixChar = '-';
                            break;
                        }
                        case CONTEXT: {
                            prefixChar = ' ';
                        }
                    }
                    String text2 = line.getText();
                    text2 = StringUtil.trimEnd((String)text2, (String)"\n");
                    UnifiedDiffWriter.writeLine(writer, text2, prefixChar);
                    if (line.isSuppressNewLine()) {
                        writer.write(lineSeparator + NO_NEWLINE_SIGNATURE + lineSeparator);
                        continue;
                    }
                    writer.write(fileContentLineSeparator);
                }
            }
        }
        for (FilePatch filePatch : noContentPatches) {
            GitPatchWriter.writeGitHeader(writer, basePath, filePatch, lineSeparator);
        }
    }

    private static String getPathRelatedToProjectDir(@Nullable Project project, @Nullable Path patchBasePath, @NotNull String filePath) {
        if (filePath == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(6);
        }
        if (project == null || patchBasePath == null) {
            return filePath;
        }
        String newBaseDir = project.getBasePath();
        if (newBaseDir == null) {
            return filePath;
        }
        String relativePath = FileUtil.getRelativePath((File)new File(newBaseDir), (File)new File(patchBasePath.toString(), filePath));
        if (relativePath == null) {
            return filePath;
        }
        return relativePath;
    }

    private static void writeFileHeading(@NotNull Writer writer, @Nullable Path basePath, @NotNull FilePatch patch, @NotNull String lineSeparator, @Nullable Map<String, CharSequence> additionalMap) throws IOException {
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(7);
        }
        if (patch == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(8);
        }
        if (lineSeparator == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(9);
        }
        writer.write(MessageFormat.format(INDEX_SIGNATURE, patch.getBeforeName(), lineSeparator));
        UnifiedDiffWriter.writeAdditionalInfo(writer, lineSeparator, additionalMap);
        writer.write(HEADER_SEPARATOR + lineSeparator);
        GitPatchWriter.writeGitHeader(writer, basePath, patch, lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "---", UnifiedDiffWriter.getRevisionHeadingPath(patch, true), patch.getBeforeVersionId(), lineSeparator);
        UnifiedDiffWriter.writeRevisionHeading(writer, "+++", UnifiedDiffWriter.getRevisionHeadingPath(patch, false), patch.getAfterVersionId(), lineSeparator);
    }

    private static void writeAdditionalInfo(@NotNull Writer writer, @NotNull String lineSeparator, @Nullable Map<String, CharSequence> additionalMap) throws IOException {
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(10);
        }
        if (lineSeparator == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(11);
        }
        if (additionalMap != null && !additionalMap.isEmpty()) {
            writer.write(ADDITIONAL_PREFIX);
            writer.write(lineSeparator);
            for (Map.Entry<String, CharSequence> entry : additionalMap.entrySet()) {
                writer.write(ADD_INFO_HEADER + entry.getKey());
                writer.write(lineSeparator);
                String value = StringUtil.escapeStringCharacters((String)entry.getValue().toString());
                List lines = StringUtil.split((String)value, (String)"\n");
                for (String line : lines) {
                    writer.write(ADD_INFO_LINE_START);
                    writer.write(line);
                    writer.write(lineSeparator);
                }
            }
        }
    }

    @NonNls
    private static String getRevisionHeadingPath(@NotNull FilePatch patch, boolean beforePath) {
        if (patch == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(12);
        }
        if (beforePath) {
            return patch.isNewFile() ? DEV_NULL : A_PREFIX + patch.getBeforeName();
        }
        return patch.isDeletedFile() ? DEV_NULL : B_PREFIX + patch.getAfterName();
    }

    private static void writeRevisionHeading(Writer writer, String prefix, String revisionPath, String revisionName, String lineSeparator) throws IOException {
        writer.write(prefix + " ");
        writer.write(revisionPath);
        writer.write("\t");
        if (!StringUtil.isEmptyOrSpaces((String)revisionName)) {
            writer.write(revisionName);
        }
        writer.write(lineSeparator);
    }

    private static void writeHunkStart(@NotNull Writer writer, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull String lineSeparator) throws IOException {
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(13);
        }
        if (lineSeparator == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(14);
        }
        writer.append(String.format("@@ -%s,%s +%s,%s @@", startLine1 + 1, endLine1 - startLine1, startLine2 + 1, endLine2 - startLine2));
        writer.append(lineSeparator);
    }

    private static void writeLine(@NotNull Writer writer, @NotNull String line, char prefix) throws IOException {
        if (writer == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(15);
        }
        if (line == null) {
            UnifiedDiffWriter.$$$reportNull$$$0(16);
        }
        writer.write(prefix);
        writer.write(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/UnifiedDiffWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "write";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathRelatedToProjectDir";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFileHeading";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "writeAdditionalInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRevisionHeadingPath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "writeHunkStart";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

