/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultCancellationTokenSource;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.parameters.FailsafeBuildProgressListenerAdapter;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class LazyConsumerActionExecutor
implements ConsumerActionExecutor {
    private final Distribution distribution;
    private final ToolingImplementationLoader implementationLoader;
    private final LoggingProvider loggingProvider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Set<Thread> executing = new HashSet<Thread>();
    private boolean stopped;
    private ConsumerConnection connection;
    private final ConnectionParameters connectionParameters;
    private BuildCancellationToken cancellationToken;

    public LazyConsumerActionExecutor(Distribution distribution, ToolingImplementationLoader implementationLoader, LoggingProvider loggingProvider, ConnectionParameters connectionParameters) {
        this.distribution = distribution;
        this.implementationLoader = implementationLoader;
        this.loggingProvider = loggingProvider;
        this.connectionParameters = connectionParameters;
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            while (!this.executing.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            this.connection = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.lock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.requestCancellation();
            this.sendStopWhenIdleMessageToDaemons();
        }
        finally {
            this.stopped = true;
            this.lock.unlock();
        }
    }

    private void requestCancellation() {
        if (this.cancellationToken != null && !this.cancellationToken.isCancellationRequested()) {
            this.cancellationToken.cancel();
        }
    }

    private void sendStopWhenIdleMessageToDaemons() {
        final ConsumerOperationParameters.Builder builder = ConsumerOperationParameters.builder();
        builder.setCancellationToken(new DefaultCancellationTokenSource().token());
        builder.setParameters(this.connectionParameters);
        builder.setEntryPoint("Request daemon shutdown when idle");
        this.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return builder.build();
            }

            @Override
            public Void run(ConsumerConnection c) {
                c.stopWhenIdle(this.getParameters());
                return null;
            }
        });
    }

    @Override
    public String getDisplayName() {
        return "connection to " + this.distribution.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(ConsumerAction<T> action) throws UnsupportedOperationException, IllegalStateException {
        try {
            ConsumerOperationParameters parameters = action.getParameters();
            this.cancellationToken = parameters.getCancellationToken();
            FailsafeBuildProgressListenerAdapter buildProgressListener = parameters.getBuildProgressListener();
            ConsumerConnection connection = this.onStartAction(this.cancellationToken, buildProgressListener);
            T t = action.run(connection);
            return t;
        }
        finally {
            this.onEndAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerConnection onStartAction(BuildCancellationToken cancellationToken, InternalBuildProgressListener buildProgressListener) {
        this.lock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException("This connection has been stopped.");
            }
            this.executing.add(Thread.currentThread());
            if (this.connection == null) {
                ProgressLoggerFactory progressLoggerFactory = this.loggingProvider.getProgressLoggerFactory();
                this.connection = this.implementationLoader.create(this.distribution, progressLoggerFactory, buildProgressListener, this.connectionParameters, cancellationToken);
            }
            ConsumerConnection consumerConnection = this.connection;
            return consumerConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onEndAction() {
        this.lock.lock();
        try {
            this.executing.remove(Thread.currentThread());
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

