/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.envjs.EnvJsExtension;
import org.gradle.plugins.javascript.envjs.browser.BrowserEvaluate;
import org.gradle.plugins.javascript.envjs.internal.EnvJsBrowserEvaluator;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoPlugin;
import org.gradle.plugins.javascript.rhino.worker.internal.DefaultRhinoWorkerHandleFactory;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class EnvJsPlugin
implements Plugin<Project> {
    private final WorkerProcessFactory workerProcessBuilderFactory;

    @Inject
    public EnvJsPlugin(WorkerProcessFactory workerProcessBuilderFactory) {
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
    }

    @Override
    public void apply(final Project project) {
        DeprecationLogger.deprecatePlugin("org.gradle.envjs").willBeRemovedInGradle7().withUpgradeGuideSection(5, "deprecated_plugins").nagUser();
        project.getPluginManager().apply(RhinoPlugin.class);
        project.getPluginManager().apply(ReportingBasePlugin.class);
        JavaScriptExtension jsExtension = project.getExtensions().getByType(JavaScriptExtension.class);
        final EnvJsExtension envJsExtension = ((ExtensionAware)((Object)jsExtension)).getExtensions().create("envJs", EnvJsExtension.class, new Object[0]);
        final Configuration configuration = this.addConfiguration(project.getConfigurations(), project.getDependencies(), envJsExtension);
        ConventionMapping conventionMapping = ((IConventionAware)((Object)envJsExtension)).getConventionMapping();
        conventionMapping.map("js", new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return configuration;
            }
        });
        conventionMapping.map("version", new Callable<String>(){

            @Override
            public String call() {
                return "1.2";
            }
        });
        final RhinoExtension rhinoExtension = ((ExtensionAware)((Object)jsExtension)).getExtensions().getByType(RhinoExtension.class);
        project.getTasks().withType(BrowserEvaluate.class, new Action<BrowserEvaluate>(){

            @Override
            public void execute(BrowserEvaluate task) {
                ((IConventionAware)((Object)task)).getConventionMapping().map("evaluator", new Callable<EnvJsBrowserEvaluator>(){

                    @Override
                    public EnvJsBrowserEvaluator call() {
                        DefaultRhinoWorkerHandleFactory handleFactory = new DefaultRhinoWorkerHandleFactory(EnvJsPlugin.this.workerProcessBuilderFactory);
                        File workDir = project.getProjectDir();
                        Factory<File> envJsFactory = new Factory<File>(){

                            @Override
                            public File create() {
                                return envJsExtension.getJs().getSingleFile();
                            }
                        };
                        return new EnvJsBrowserEvaluator(handleFactory, rhinoExtension.getClasspath(), envJsFactory, project.getGradle().getStartParameter().getLogLevel(), workDir);
                    }
                });
            }
        });
    }

    public Configuration addConfiguration(ConfigurationContainer configurations, final DependencyHandler dependencies, final EnvJsExtension extension) {
        Configuration configuration = (Configuration)configurations.create("envJsPlugin");
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet configDependencies) {
                String notation = "com.envjs:envjs.rhino:" + extension.getVersion() + "@js";
                Dependency dependency = dependencies.create(notation);
                configDependencies.add(dependency);
            }
        });
        return configuration;
    }
}

