/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.routes;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.routes.RoutesCompileSpec;
import org.gradle.play.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaMethod;

public class RoutesCompiler
implements Compiler<RoutesCompileSpec>,
Serializable {
    private final VersionedRoutesCompilerAdapter adapter;

    @Inject
    public RoutesCompiler(VersionedRoutesCompilerAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public WorkResult execute(RoutesCompileSpec spec) {
        Boolean ret;
        boolean didWork = false;
        ArrayList primaryRoutes = Lists.newArrayList();
        ArrayList secondaryRoutes = Lists.newArrayList();
        for (File source : spec.getSources()) {
            if (source.getName().equals("routes")) {
                primaryRoutes.add(source);
                continue;
            }
            secondaryRoutes.add(source);
        }
        for (File sourceFile : secondaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        for (File sourceFile : primaryRoutes) {
            ret = this.compile(sourceFile, spec);
            didWork = ret != false || didWork;
        }
        return WorkResults.didWork(didWork);
    }

    private Boolean compile(File sourceFile, RoutesCompileSpec spec) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            ScalaMethod compile = this.adapter.getCompileMethod(cl);
            return this.adapter.interpretResult(compile.invoke(this.adapter.createCompileParameters(cl, sourceFile, spec.getDestinationDir(), spec.isJavaProject(), spec.isNamespaceReverseRouter(), spec.isGenerateReverseRoutes(), spec.isInjectedRoutesGenerator(), spec.getAdditionalImports())));
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking the Play routes compiler.", e);
        }
    }
}

