/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.internal.resolve.NativeBinaryRequirementResolveResult;
import org.gradle.util.CollectionUtils;

public class NativeBinaryResolveResult {
    private final NativeBinarySpec target;
    private final List<NativeBinaryRequirementResolveResult> resolutions = new ArrayList<NativeBinaryRequirementResolveResult>();

    public NativeBinaryResolveResult(NativeBinarySpec target, Collection<?> libs) {
        this.target = target;
        for (Object lib : libs) {
            this.resolutions.add(new NativeBinaryRequirementResolveResult(lib));
        }
    }

    public NativeBinarySpec getTarget() {
        return this.target;
    }

    public List<NativeBinaryRequirementResolveResult> getAllResolutions() {
        return this.resolutions;
    }

    public List<NativeDependencySet> getAllResults() {
        return CollectionUtils.collect(this.getAllResolutions(), new Transformer<NativeDependencySet, NativeBinaryRequirementResolveResult>(){

            @Override
            public NativeDependencySet transform(NativeBinaryRequirementResolveResult original) {
                return original.getNativeDependencySet();
            }
        });
    }

    public List<NativeLibraryBinary> getAllLibraryBinaries() {
        ArrayList<NativeLibraryBinary> result = new ArrayList<NativeLibraryBinary>();
        for (NativeBinaryRequirementResolveResult resolution : this.getAllResolutions()) {
            if (resolution.getLibraryBinary() == null) continue;
            result.add(resolution.getLibraryBinary());
        }
        return result;
    }

    public List<NativeBinaryRequirementResolveResult> getPendingResolutions() {
        return CollectionUtils.filter(this.resolutions, new Spec<NativeBinaryRequirementResolveResult>(){

            @Override
            public boolean isSatisfiedBy(NativeBinaryRequirementResolveResult element) {
                return !element.isComplete();
            }
        });
    }
}

