/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.type.ModelType;

@ThreadSafe
public class UnboundRuleInput {
    private final String path;
    private final String type;
    private final boolean bound;
    private final String description;
    private final ImmutableList<String> suggestedPaths;
    private final String scope;

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public boolean isBound() {
        return this.bound;
    }

    public ImmutableList<? extends String> getSuggestedPaths() {
        return this.suggestedPaths;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScope() {
        return this.scope;
    }

    private UnboundRuleInput(String path, String type, boolean bound, ImmutableList<String> suggestedPaths, String description, String scope) {
        this.path = path;
        this.type = type;
        this.bound = bound;
        this.suggestedPaths = suggestedPaths;
        this.description = description;
        this.scope = scope;
    }

    public static Builder type(String type) {
        return new Builder(type);
    }

    public static Builder type(Class<?> type) {
        return UnboundRuleInput.type(ModelType.of(type));
    }

    public static Builder type(ModelType<?> type) {
        return UnboundRuleInput.type(type.getDisplayName());
    }

    @NotThreadSafe
    public static class Builder {
        private String path;
        private String type;
        private boolean bound;
        private ImmutableList.Builder<String> suggestedPaths = ImmutableList.builder();
        private String description;
        private String scope;

        private Builder(String type) {
            this.type = type;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder path(ModelPath path) {
            return this.path(path.toString());
        }

        public Builder bound() {
            this.bound = true;
            return this;
        }

        public Builder suggestions(Collection<? extends String> suggestedPaths) {
            this.suggestedPaths.addAll(suggestedPaths);
            return this;
        }

        public Builder suggestions(String ... suggestedPath) {
            return this.suggestions(Arrays.asList(suggestedPath));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public UnboundRuleInput build() {
            return new UnboundRuleInput(this.path, this.type, this.bound, this.suggestedPaths.build(), this.description, this.scope);
        }
    }
}

