/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import java.io.File;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public class CppLibraryPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppLibraryPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        ObjectFactory objectFactory = project.getObjects();
        ProviderFactory providers = project.getProviders();
        final DefaultCppLibrary library = this.componentFactory.newInstance(CppLibrary.class, DefaultCppLibrary.class, "main");
        project.getExtensions().add(CppLibrary.class, "library", library);
        project.getComponents().add(library);
        library.getBaseName().convention(project.getName());
        library.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        library.getDevelopmentBinary().convention(project.provider(new Callable<CppBinary>(){

            @Override
            public CppBinary call() throws Exception {
                return this.getDebugSharedHostStream().findFirst().orElse(this.getDebugStaticHostStream().findFirst().orElse(this.getDebugSharedStream().findFirst().orElse(this.getDebugStaticStream().findFirst().orElse(null))));
            }

            private Stream<CppBinary> getDebugStream() {
                return ((DefaultBinaryCollection)library.getBinaries()).get().stream().filter(binary -> !binary.isOptimized());
            }

            private Stream<CppBinary> getDebugSharedStream() {
                return this.getDebugStream().filter(CppSharedLibrary.class::isInstance);
            }

            private Stream<CppBinary> getDebugSharedHostStream() {
                return this.getDebugSharedStream().filter(binary -> Architectures.forInput(binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture()));
            }

            private Stream<CppBinary> getDebugStaticStream() {
                return this.getDebugStream().filter(CppStaticLibrary.class::isInstance);
            }

            private Stream<CppBinary> getDebugStaticHostStream() {
                return this.getDebugStaticStream().filter(binary -> Architectures.forInput(binary.getTargetMachine().getArchitecture().getName()).equals(DefaultNativePlatform.host().getArchitecture()));
            }
        }));
        ((DefaultBinaryCollection)library.getBinaries()).whenElementKnown(binary -> library.getMainPublication().addVariant((SoftwareComponent)binary));
        project.afterEvaluate(p -> {
            Dimensions.libraryVariants(library.getBaseName(), library.getLinkage(), library.getTargetMachines(), objectFactory, this.attributesFactory, providers.provider(() -> project.getGroup().toString()), providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    ToolChainSelector.Result<DefaultCppPlatform> result = this.toolChainSelector.select(CppPlatform.class, new DefaultCppPlatform(variantIdentity.getTargetMachine()));
                    if (variantIdentity.getLinkage().equals(Linkage.SHARED)) {
                        library.addSharedLibrary((NativeVariantIdentity)variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    } else {
                        library.addStaticLibrary((NativeVariantIdentity)variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    }
                } else {
                    library.getMainPublication().addVariant((SoftwareComponent)variantIdentity);
                }
            });
            Configuration apiElements = library.getApiElements();
            Provider<File> publicHeaders = providers.provider(() -> {
                Set<File> files2 = library.getPublicHeaderDirs().getFiles();
                if (files2.size() != 1) {
                    throw new UnsupportedOperationException(String.format("The C++ library plugin currently requires exactly one public header directory, however there are %d directories configured: %s", files2.size(), files2));
                }
                return files2.iterator().next();
            });
            apiElements.getOutgoing().artifact(publicHeaders);
            project.getPluginManager().withPlugin("maven-publish", appliedPlugin -> {
                NamedDomainObjectProvider headersZip = tasks.register("cppHeaders", Zip.class, task -> {
                    task.from(library.getPublicHeaderFiles());
                    task.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir("headers"));
                    task.getArchiveClassifier().set("cpp-api-headers");
                    task.getArchiveFileName().set("cpp-api-headers.zip");
                });
                library.getMainPublication().addArtifact(new LazyPublishArtifact(headersZip));
            });
            ((DefaultBinaryCollection)library.getBinaries()).realizeNow();
        });
    }
}

