/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.resource.cached.AbstractCachedIndex;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.cached.DefaultCachedExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultCachedExternalResourceIndex<K extends Serializable>
extends AbstractCachedIndex<K, CachedExternalResource>
implements CachedExternalResourceIndex<K> {
    private final BuildCommencedTimeProvider timeProvider;

    public DefaultCachedExternalResourceIndex(String persistentCacheFile, Serializer<K> keySerializer, BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingManager artifactCacheLockingManager, FileAccessTracker fileAccessTracker2, Path commonRootPath) {
        super(persistentCacheFile, keySerializer, new CachedExternalResourceSerializer(commonRootPath), artifactCacheLockingManager, fileAccessTracker2);
        this.timeProvider = timeProvider;
    }

    private DefaultCachedExternalResource createEntry(File artifactFile, ExternalResourceMetaData externalResourceMetaData) {
        return new DefaultCachedExternalResource(artifactFile, this.timeProvider.getCurrentTime(), externalResourceMetaData);
    }

    @Override
    public void store(K key, File artifactFile, ExternalResourceMetaData externalResourceMetaData) {
        this.assertArtifactFileNotNull(artifactFile);
        this.assertKeyNotNull(key);
        this.storeInternal(key, this.createEntry(artifactFile, externalResourceMetaData));
    }

    @Override
    public void storeMissing(K key) {
        this.storeInternal(key, new DefaultCachedExternalResource(this.timeProvider.getCurrentTime()));
    }

    @VisibleForTesting
    static class CachedExternalResourceSerializer
    implements Serializer<CachedExternalResource> {
        private final Path commonRootPath;

        public CachedExternalResourceSerializer(Path commonRootPath) {
            this.commonRootPath = commonRootPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedExternalResourceSerializer that = (CachedExternalResourceSerializer)o;
            return this.commonRootPath.equals(that.commonRootPath);
        }

        public int hashCode() {
            return this.commonRootPath.hashCode();
        }

        @Override
        public CachedExternalResource read(Decoder decoder) throws Exception {
            File cachedFile = null;
            if (decoder.readBoolean()) {
                cachedFile = this.denormalizeAndResolveFilePath(decoder.readString());
            }
            long cachedAt = decoder.readLong();
            DefaultExternalResourceMetaData metaData = null;
            if (decoder.readBoolean()) {
                URI uri = new URI(decoder.readString());
                long lastModified = 0L;
                if (decoder.readBoolean()) {
                    lastModified = decoder.readLong();
                }
                String contentType = decoder.readNullableString();
                long contentLength = decoder.readSmallLong();
                String etag = decoder.readNullableString();
                HashCode sha1 = null;
                if (decoder.readBoolean()) {
                    sha1 = HashCode.fromString(decoder.readString());
                }
                metaData = new DefaultExternalResourceMetaData(uri, lastModified, contentLength, contentType, etag, sha1);
            }
            return new DefaultCachedExternalResource(cachedFile, cachedAt, metaData);
        }

        @Override
        public void write(Encoder encoder, CachedExternalResource value) throws Exception {
            encoder.writeBoolean(value.getCachedFile() != null);
            if (value.getCachedFile() != null) {
                encoder.writeString(this.relativizeAndNormalizeFilePath(value.getCachedFile()));
            }
            encoder.writeLong(value.getCachedAt());
            ExternalResourceMetaData metaData = value.getExternalResourceMetaData();
            encoder.writeBoolean(metaData != null);
            if (metaData != null) {
                encoder.writeString(metaData.getLocation().toASCIIString());
                encoder.writeBoolean(metaData.getLastModified() != null);
                if (metaData.getLastModified() != null) {
                    encoder.writeLong(metaData.getLastModified().getTime());
                }
                encoder.writeNullableString(metaData.getContentType());
                encoder.writeSmallLong(metaData.getContentLength());
                encoder.writeNullableString(metaData.getEtag());
                encoder.writeBoolean(metaData.getSha1() != null);
                if (metaData.getSha1() != null) {
                    encoder.writeString(metaData.getSha1().toString());
                }
            }
        }

        private String relativizeAndNormalizeFilePath(File cachedFile) {
            Path filePath = cachedFile.toPath();
            assert (filePath.startsWith(this.commonRootPath)) : "Attempting to cache file " + filePath + " not in " + this.commonRootPath;
            String systemDependentPath = this.commonRootPath.relativize(filePath).toString();
            if (!filePath.getFileSystem().getSeparator().equals("/")) {
                return systemDependentPath.replace(filePath.getFileSystem().getSeparator(), "/");
            }
            return systemDependentPath;
        }

        private File denormalizeAndResolveFilePath(String relativePath) throws IOException {
            if (!this.commonRootPath.getFileSystem().getSeparator().equals("/")) {
                relativePath = relativePath.replace("/", this.commonRootPath.getFileSystem().getSeparator());
            }
            return this.commonRootPath.resolve(relativePath).toFile();
        }
    }
}

