/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.operations.trace.SerializedOperation;

class SerializedOperationProgress
implements SerializedOperation {
    final long id;
    final long time;
    final Object details;
    final String detailsClassName;

    SerializedOperationProgress(OperationIdentifier id, OperationProgressEvent progressEvent) {
        this.id = id.getId();
        this.time = progressEvent.getTime();
        this.details = BuildOperationTrace.toSerializableModel(progressEvent.getDetails());
        this.detailsClassName = this.details == null ? null : progressEvent.getDetails().getClass().getName();
    }

    SerializedOperationProgress(Map<String, ?> map2) {
        this.id = ((Integer)map2.get("id")).longValue();
        this.time = (Long)map2.get("time");
        this.details = map2.get("details");
        this.detailsClassName = (String)map2.get("detailsClassName");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder map2 = ImmutableMap.builder();
        if (this.details != null) {
            map2.put((Object)"details", this.details);
            map2.put((Object)"detailsClassName", (Object)this.detailsClassName);
        }
        map2.put((Object)"id", (Object)this.id);
        map2.put((Object)"time", (Object)this.time);
        return map2.build();
    }
}

