/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public abstract class AbstractFingerprintCompareStrategy
implements FingerprintCompareStrategy {
    @Override
    public boolean visitChangesSince(FileCollectionFingerprint current, FileCollectionFingerprint previous, String propertyTitle, ChangeVisitor visitor) {
        if (this.hasSameRootHashes(current, previous)) {
            return true;
        }
        return this.visitChangesSince(current.getFingerprints(), previous.getFingerprints(), propertyTitle, visitor);
    }

    private boolean hasSameRootHashes(FileCollectionFingerprint current, FileCollectionFingerprint previous) {
        return Iterables.elementsEqual((Iterable)current.getRootHashes().entries(), (Iterable)previous.getRootHashes().entries());
    }

    private boolean visitChangesSince(Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle, ChangeVisitor visitor) {
        Boolean trivialResult = AbstractFingerprintCompareStrategy.compareTrivialFingerprints(visitor, current, previous, propertyTitle);
        if (trivialResult != null) {
            return trivialResult;
        }
        return this.doVisitChangesSince(visitor, current, previous, propertyTitle);
    }

    protected abstract boolean doVisitChangesSince(ChangeVisitor var1, Map<String, FileSystemLocationFingerprint> var2, Map<String, FileSystemLocationFingerprint> var3, String var4);

    @Nullable
    @VisibleForTesting
    static Boolean compareTrivialFingerprints(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, Map<String, FileSystemLocationFingerprint> previous, String propertyTitle) {
        switch (current.size()) {
            case 0: {
                switch (previous.size()) {
                    case 0: {
                        return true;
                    }
                }
                for (Map.Entry<String, FileSystemLocationFingerprint> entry : previous.entrySet()) {
                    DefaultFileChange change = DefaultFileChange.removed(entry.getKey(), propertyTitle, entry.getValue().getType(), entry.getValue().getNormalizedPath());
                    if (visitor.visitChange(change)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        return AbstractFingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle);
                    }
                    case 1: {
                        Map.Entry<String, FileSystemLocationFingerprint> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, FileSystemLocationFingerprint> currentEntry = current.entrySet().iterator().next();
                        return AbstractFingerprintCompareStrategy.compareTrivialFingerprintEntries(visitor, currentEntry, previousEntry, propertyTitle);
                    }
                }
                return null;
            }
        }
        if (!previous.isEmpty()) {
            return null;
        }
        return AbstractFingerprintCompareStrategy.reportAllAdded(visitor, current, propertyTitle);
    }

    private static boolean reportAllAdded(ChangeVisitor visitor, Map<String, FileSystemLocationFingerprint> current, String propertyTitle) {
        for (Map.Entry<String, FileSystemLocationFingerprint> entry : current.entrySet()) {
            DefaultFileChange change = DefaultFileChange.added(entry.getKey(), propertyTitle, entry.getValue().getType(), entry.getValue().getNormalizedPath());
            if (visitor.visitChange(change)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareTrivialFingerprintEntries(ChangeVisitor visitor, Map.Entry<String, FileSystemLocationFingerprint> currentEntry, Map.Entry<String, FileSystemLocationFingerprint> previousEntry, String propertyTitle) {
        FileSystemLocationFingerprint previousFingerprint = previousEntry.getValue();
        FileSystemLocationFingerprint currentFingerprint = currentEntry.getValue();
        if (currentFingerprint.getNormalizedPath().equals(previousFingerprint.getNormalizedPath())) {
            HashCode previousContent = previousFingerprint.getNormalizedContentHash();
            HashCode currentContent = currentFingerprint.getNormalizedContentHash();
            if (!currentContent.equals(previousContent)) {
                String path = currentEntry.getKey();
                DefaultFileChange change = DefaultFileChange.modified(path, propertyTitle, previousFingerprint.getType(), currentFingerprint.getType(), currentFingerprint.getNormalizedPath());
                return visitor.visitChange(change);
            }
            return true;
        }
        String previousPath = previousEntry.getKey();
        DefaultFileChange remove = DefaultFileChange.removed(previousPath, propertyTitle, previousFingerprint.getType(), previousFingerprint.getNormalizedPath());
        String currentPath = currentEntry.getKey();
        DefaultFileChange add = DefaultFileChange.added(currentPath, propertyTitle, currentFingerprint.getType(), currentFingerprint.getNormalizedPath());
        return visitor.visitChange(remove) && visitor.visitChange(add);
    }
}

