/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.gradle.api.UncheckedIOException;

public final class UncheckedException
extends RuntimeException {
    private UncheckedException(Throwable cause) {
        super(cause);
    }

    private UncheckedException(String message2, Throwable cause) {
        super(message2, cause);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        return UncheckedException.throwAsUncheckedException(t, false);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t, boolean preserveMessage) {
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            if (preserveMessage) {
                throw new UncheckedIOException(t.getMessage(), t);
            }
            throw new UncheckedIOException(t);
        }
        if (preserveMessage) {
            throw new UncheckedException(t.getMessage(), t);
        }
        throw new UncheckedException(t);
    }

    public static <T> T callUnchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static RuntimeException unwrapAndRethrow(InvocationTargetException e) {
        return UncheckedException.throwAsUncheckedException(e.getTargetException());
    }
}

