/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final Properties properties = new Properties();
    private final Action<? super PersistentCache> initAction;

    public DefaultPersistentDirectoryCache(File dir, String displayName, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initAction, CleanupAction cleanupAction, FileLockManager lockManager, ExecutorFactory executorFactory, ProgressLoggerFactory progressLoggerFactory) {
        super(dir, displayName, lockTarget, lockOptions, cleanupAction, lockManager, executorFactory, progressLoggerFactory);
        this.initAction = initAction;
        this.properties.putAll(properties);
    }

    @Override
    protected CacheInitializationAction getInitAction() {
        return new Initializer();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private class Initializer
    implements CacheInitializationAction {
        private Initializer() {
        }

        @Override
        public boolean requiresInitialization(FileLock lock) {
            if (!lock.getUnlockedCleanly()) {
                if (lock.getState().canDetectChanges() && !lock.getState().isInInitialState()) {
                    LOGGER.warn("Invalidating {} as it was not closed cleanly.", (Object)DefaultPersistentDirectoryCache.this);
                }
                return true;
            }
            if (!DefaultPersistentDirectoryCache.this.properties.isEmpty()) {
                if (!DefaultPersistentDirectoryCache.this.propertiesFile.exists()) {
                    LOGGER.debug("Invalidating {} as cache properties file {} is missing and cache properties are not empty.", (Object)DefaultPersistentDirectoryCache.this, (Object)DefaultPersistentDirectoryCache.this.propertiesFile.getAbsolutePath());
                    return true;
                }
                Properties cachedProperties = GUtil.loadProperties(DefaultPersistentDirectoryCache.this.propertiesFile);
                for (Map.Entry<Object, Object> entry : DefaultPersistentDirectoryCache.this.properties.entrySet()) {
                    String previousValue = cachedProperties.getProperty(entry.getKey().toString());
                    String currentValue = entry.getValue().toString();
                    if (currentValue.equals(previousValue)) continue;
                    LOGGER.debug("Invalidating {} as cache property {} has changed from {} to {}.", new Object[]{DefaultPersistentDirectoryCache.this, entry.getKey(), previousValue, currentValue});
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initialize(FileLock fileLock) {
            File[] files2 = DefaultPersistentDirectoryCache.this.getBaseDir().listFiles();
            if (files2 == null) {
                throw new UncheckedIOException("Cannot list files in " + DefaultPersistentDirectoryCache.this.getBaseDir());
            }
            for (File file : files2) {
                if (fileLock.isLockFile(file) || file.equals(DefaultPersistentDirectoryCache.this.propertiesFile)) continue;
                GFileUtils.forceDelete(file);
            }
            if (DefaultPersistentDirectoryCache.this.initAction != null) {
                DefaultPersistentDirectoryCache.this.initAction.execute(DefaultPersistentDirectoryCache.this);
            }
            GUtil.saveProperties(DefaultPersistentDirectoryCache.this.properties, DefaultPersistentDirectoryCache.this.propertiesFile);
        }
    }
}

