/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.NestedRootBuild;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.invocation.BuildController;

public class GradleBuild
extends ConventionTask {
    private final BuildState currentBuild = this.getServices().get(BuildState.class);
    private final BuildStateRegistry buildStateRegistry = this.getServices().get(BuildStateRegistry.class);
    private StartParameter startParameter = this.getServices().get(StartParameter.class).newBuild();
    private String buildName;

    public GradleBuild() {
        this.startParameter.setCurrentDir(this.getProject().getProjectDir());
    }

    @Internal
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Internal
    public File getDir() {
        return this.getStartParameter().getCurrentDir();
    }

    public void setDir(File dir) {
        this.setDir((Object)dir);
    }

    public void setDir(Object dir) {
        this.getStartParameter().setCurrentDir(this.getProject().file(dir));
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFile
    public File getBuildFile() {
        return this.getStartParameter().getBuildFile();
    }

    public void setBuildFile(@Nullable File file) {
        this.setBuildFile((Object)file);
    }

    public void setBuildFile(@Nullable Object file) {
        this.getStartParameter().setBuildFile(this.getProject().file(file));
    }

    @Input
    public List<String> getTasks() {
        return this.getStartParameter().getTaskNames();
    }

    public void setTasks(List<String> tasks) {
        this.setTasks((Collection<String>)tasks);
    }

    public void setTasks(Collection<String> tasks) {
        this.getStartParameter().setTaskNames(tasks);
    }

    @Incubating
    @Internal
    public String getBuildName() {
        return this.buildName;
    }

    @Incubating
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void build() {
        NestedRootBuild nestedBuild;
        BuildDefinition buildDefinition = BuildDefinition.fromStartParameter(this.getStartParameter(), this.getServices().get(PublicBuildPath.class));
        BuildStateRegistry buildStateRegistry = this.buildStateRegistry;
        synchronized (buildStateRegistry) {
            nestedBuild = this.buildStateRegistry.addNestedBuildTree(buildDefinition, this.currentBuild, this.buildName);
        }
        nestedBuild.run(new Transformer<Void, BuildController>(){

            @Override
            public Void transform(BuildController buildController) {
                buildController.run();
                return null;
            }
        });
    }
}

