/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.plugins;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.GenerateBuildDashboard;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.TaskProvider;

public class BuildDashboardPlugin
implements Plugin<Project> {
    public static final String BUILD_DASHBOARD_TASK_NAME = "buildDashboard";

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        NamedDomainObjectProvider buildDashboard = project.getTasks().register(BUILD_DASHBOARD_TASK_NAME, GenerateBuildDashboard.class, new Action<GenerateBuildDashboard>(){

            @Override
            public void execute(GenerateBuildDashboard buildDashboardTask) {
                buildDashboardTask.setDescription("Generates a dashboard of all the reports produced by this build.");
                buildDashboardTask.setGroup("reporting");
                DirectoryReport htmlReport = buildDashboardTask.getReports().getHtml();
                htmlReport.getOutputLocation().convention(project.getLayout().getProjectDirectory().dir(project.provider(() -> project.getExtensions().getByType(ReportingExtension.class).file(BuildDashboardPlugin.BUILD_DASHBOARD_TASK_NAME).getAbsolutePath())));
            }
        });
        for (Project aProject : project.getAllprojects()) {
            aProject.getTasks().configureEach(new Action<Task>((TaskProvider)buildDashboard){
                final /* synthetic */ TaskProvider val$buildDashboard;
                {
                    this.val$buildDashboard = taskProvider;
                }

                @Override
                public void execute(Task task) {
                    if (!(task instanceof Reporting)) {
                        return;
                    }
                    if (!task.getName().equals(BuildDashboardPlugin.BUILD_DASHBOARD_TASK_NAME)) {
                        task.finalizedBy(this.val$buildDashboard);
                    }
                }
            });
        }
    }
}

