/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.language.scala.tasks.AbstractScalaCompile;

public class ScalaPlugin
implements Plugin<Project> {
    public static final String SCALA_DOC_TASK_NAME = "scaladoc";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(ScalaBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSet main = (SourceSet)project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().getByName("main");
        ScalaPlugin.configureScaladoc(project, main);
        Configuration incrementalAnalysisElements = project.getConfigurations().getByName("incrementalScalaAnalysisElements");
        String compileTaskName = main.getCompileTaskName("scala");
        NamedDomainObjectProvider compileScala = project.getTasks().withType(AbstractScalaCompile.class).named(compileTaskName);
        final Provider<RegularFile> compileScalaMapping = project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + compileTaskName + ".mapping");
        compileScala.configure(new Action<AbstractScalaCompile>(){

            @Override
            public void execute(AbstractScalaCompile task) {
                task.getAnalysisMappingFile().set(compileScalaMapping);
            }
        });
        incrementalAnalysisElements.getOutgoing().artifact(compileScalaMapping, (Action<? super ConfigurablePublishArtifact>)new Action<ConfigurablePublishArtifact>((TaskProvider)compileScala){
            final /* synthetic */ TaskProvider val$compileScala;
            {
                this.val$compileScala = taskProvider;
            }

            @Override
            public void execute(ConfigurablePublishArtifact configurablePublishArtifact) {
                configurablePublishArtifact.builtBy(this.val$compileScala);
            }
        });
    }

    private static void configureScaladoc(final Project project, final SourceSet main) {
        project.getTasks().withType(ScalaDoc.class).configureEach(new Action<ScalaDoc>(){

            @Override
            public void execute(ScalaDoc scalaDoc) {
                scalaDoc.getConventionMapping().map("classpath", new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        ConfigurableFileCollection files2 = project.files(new Object[0]);
                        files2.from(main.getOutput());
                        files2.from(main.getCompileClasspath());
                        return files2;
                    }
                });
                scalaDoc.setSource(InvokerHelper.invokeMethod((Object)main, (String)"getScala", null));
            }
        });
        project.getTasks().register(SCALA_DOC_TASK_NAME, ScalaDoc.class, new Action<ScalaDoc>(){

            @Override
            public void execute(ScalaDoc scalaDoc) {
                scalaDoc.setDescription("Generates Scaladoc for the main source code.");
                scalaDoc.setGroup("documentation");
            }
        });
    }
}

