/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.CodeNarcReports;
import org.gradle.api.plugins.quality.internal.CodeNarcInvoker;
import org.gradle.api.plugins.quality.internal.CodeNarcReportsImpl;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.util.ClosureBackedAction;

@CacheableTask
public class CodeNarc
extends SourceTask
implements VerificationTask,
Reporting<CodeNarcReports> {
    private FileCollection codenarcClasspath;
    private FileCollection compilationClasspath;
    private TextResource config;
    private int maxPriority1Violations;
    private int maxPriority2Violations;
    private int maxPriority3Violations;
    private final CodeNarcReports reports = this.getObjectFactory().newInstance(CodeNarcReportsImpl.class, this);
    private boolean ignoreFailures;

    public CodeNarc() {
        this.compilationClasspath = this.getProject().files(new Object[0]);
    }

    @Internal
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile(configFile));
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void run() {
        CodeNarcInvoker.invoke(this);
    }

    @Override
    public CodeNarcReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public CodeNarcReports reports(Action<? super CodeNarcReports> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    @Classpath
    public FileCollection getCodenarcClasspath() {
        return this.codenarcClasspath;
    }

    public void setCodenarcClasspath(FileCollection codenarcClasspath) {
        this.codenarcClasspath = codenarcClasspath;
    }

    @Incubating
    @Classpath
    public FileCollection getCompilationClasspath() {
        return this.compilationClasspath;
    }

    @Incubating
    public void setCompilationClasspath(FileCollection compilationClasspath) {
        this.compilationClasspath = compilationClasspath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Input
    public int getMaxPriority1Violations() {
        return this.maxPriority1Violations;
    }

    public void setMaxPriority1Violations(int maxPriority1Violations) {
        this.maxPriority1Violations = maxPriority1Violations;
    }

    @Input
    public int getMaxPriority2Violations() {
        return this.maxPriority2Violations;
    }

    public void setMaxPriority2Violations(int maxPriority2Violations) {
        this.maxPriority2Violations = maxPriority2Violations;
    }

    @Input
    public int getMaxPriority3Violations() {
        return this.maxPriority3Violations;
    }

    public void setMaxPriority3Violations(int maxPriority3Violations) {
        this.maxPriority3Violations = maxPriority3Violations;
    }

    @Override
    @Nested
    public CodeNarcReports getReports() {
        return this.reports;
    }

    @Override
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }
}

