/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.java.DefaultJavaPlatformExtension;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.internal.component.external.model.DefaultShadowedCapability;
import org.gradle.internal.component.external.model.JavaEcosystemVariantDerivationStrategy;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class JavaPlatformPlugin
implements Plugin<Project> {
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String ENFORCED_API_ELEMENTS_CONFIGURATION_NAME = "enforcedApiElements";
    public static final String ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME = "enforcedRuntimeElements";
    public static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final Action<Configuration> AS_CONSUMABLE_CONFIGURATION = conf -> {
        conf.setCanBeResolved(false);
        conf.setCanBeConsumed(true);
    };
    private static final Action<Configuration> AS_BUCKET = conf -> {
        conf.setCanBeResolved(false);
        conf.setCanBeConsumed(false);
    };
    private static final Action<Configuration> AS_RESOLVABLE_CONFIGURATION = conf -> {
        conf.setCanBeResolved(true);
        conf.setCanBeConsumed(false);
    };
    private static final String DISALLOW_DEPENDENCIES = "Adding dependencies to platforms is not allowed by default.\nMost likely you want to add constraints instead.\nIf you did this intentionally, you need to configure the platform extension to allow dependencies:\n    javaPlatform.allowDependencies()\nFound dependencies in the '%s' configuration.";
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public JavaPlatformPlugin(SoftwareComponentFactory softwareComponentFactory) {
        this.softwareComponentFactory = softwareComponentFactory;
    }

    @Override
    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java")) {
            throw new IllegalStateException("The \"java-platform\" plugin cannot be applied together with the \"java\" (or \"java-library\") plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        project.getPluginManager().apply(BasePlugin.class);
        this.createConfigurations(project);
        this.configureExtension(project);
        JavaEcosystemSupport.configureSchema(project.getDependencies().getAttributesSchema(), project.getObjects());
        JavaPlatformPlugin.configureVariantDerivationStrategy((ProjectInternal)project);
    }

    private static void configureVariantDerivationStrategy(ProjectInternal project) {
        ComponentMetadataHandlerInternal metadataHandler = (ComponentMetadataHandlerInternal)((Object)project.getDependencies().getComponents());
        metadataHandler.setVariantDerivationStrategy(JavaEcosystemVariantDerivationStrategy.getInstance());
    }

    private void createSoftwareComponent(Project project, Configuration apiElements, Configuration runtimeElements) {
        AdhocComponentWithVariants component = this.softwareComponentFactory.adhoc("javaPlatform");
        project.getComponents().add(component);
        component.addVariantsFromConfiguration(apiElements, new JavaConfigurationVariantMapping("compile", false));
        component.addVariantsFromConfiguration(runtimeElements, new JavaConfigurationVariantMapping(RUNTIME_CONFIGURATION_NAME, false));
    }

    private void createConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        DefaultShadowedCapability enforcedCapability = new DefaultShadowedCapability(new ProjectDerivedCapability(project), "-derived-enforced-platform");
        Configuration api = configurations.create(API_CONFIGURATION_NAME, AS_BUCKET);
        Configuration apiElements = this.createConsumableApi(project, configurations, api, API_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedApiElements = this.createConsumableApi(project, configurations, api, ENFORCED_API_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        enforcedApiElements.getOutgoing().capability(enforcedCapability);
        Configuration runtime = project.getConfigurations().create(RUNTIME_CONFIGURATION_NAME, AS_BUCKET);
        runtime.extendsFrom(api);
        Configuration runtimeElements = this.createConsumableRuntime(project, runtime, RUNTIME_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedRuntimeElements = this.createConsumableRuntime(project, runtime, ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        enforcedRuntimeElements.getOutgoing().capability(enforcedCapability);
        Configuration classpath = configurations.create(CLASSPATH_CONFIGURATION_NAME, AS_RESOLVABLE_CONFIGURATION);
        classpath.extendsFrom(runtimeElements);
        this.declareConfigurationUsage(project.getObjects(), classpath, "java-runtime", "jar");
        this.createSoftwareComponent(project, apiElements, runtimeElements);
    }

    private Configuration createConsumableRuntime(Project project, Configuration apiElements, String name, String platformKind) {
        Configuration runtimeElements = project.getConfigurations().create(name, AS_CONSUMABLE_CONFIGURATION);
        runtimeElements.extendsFrom(apiElements);
        this.declareConfigurationUsage(project.getObjects(), runtimeElements, "java-runtime");
        this.declareConfigurationCategory(project.getObjects(), runtimeElements, platformKind);
        return runtimeElements;
    }

    private Configuration createConsumableApi(Project project, ConfigurationContainer configurations, Configuration api, String name, String platformKind) {
        Configuration apiElements = configurations.create(name, AS_CONSUMABLE_CONFIGURATION);
        apiElements.extendsFrom(api);
        this.declareConfigurationUsage(project.getObjects(), apiElements, "java-api");
        this.declareConfigurationCategory(project.getObjects(), apiElements, platformKind);
        return apiElements;
    }

    private void declareConfigurationCategory(ObjectFactory objectFactory, Configuration configuration, String value) {
        configuration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, objectFactory.named(Category.class, value));
    }

    private void declareConfigurationUsage(ObjectFactory objectFactory, Configuration configuration, String usage, String libraryContents) {
        this.declareConfigurationUsage(objectFactory, configuration, usage);
        configuration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, objectFactory.named(LibraryElements.class, libraryContents));
    }

    private void declareConfigurationUsage(ObjectFactory objectFactory, Configuration configuration, String usage) {
        configuration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, objectFactory.named(Usage.class, usage));
    }

    private void configureExtension(Project project) {
        DefaultJavaPlatformExtension platformExtension = project.getExtensions().create(JavaPlatformExtension.class, "javaPlatform", DefaultJavaPlatformExtension.class, new Object[0]);
        project.afterEvaluate(project1 -> {
            if (!platformExtension.isAllowDependencies()) {
                this.checkNoDependencies((Project)project1);
            }
        });
    }

    private void checkNoDependencies(Project project) {
        this.checkNoDependencies(project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME), Sets.newHashSet());
    }

    private void checkNoDependencies(Configuration configuration, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            if (!configuration.getDependencies().isEmpty()) {
                throw new InvalidUserCodeException(String.format(DISALLOW_DEPENDENCIES, configuration.getName()));
            }
            Set<Configuration> extendsFrom = configuration.getExtendsFrom();
            for (Configuration parent : extendsFrom) {
                this.checkNoDependencies(parent, visited);
            }
        }
    }
}

