/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.java.archives.internal;

import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.java.archives.internal.DefaultAttributes;
import org.gradle.api.java.archives.internal.DefaultManifestMergeSpec;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.IoActions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.util.ClosureBackedAction;

public class DefaultManifest
implements ManifestInternal {
    public static final String DEFAULT_CONTENT_CHARSET = "UTF-8";
    private List<ManifestMergeSpec> manifestMergeSpecs = new ArrayList<ManifestMergeSpec>();
    private DefaultAttributes attributes = new DefaultAttributes();
    private Map<String, Attributes> sections = new LinkedHashMap<String, Attributes>();
    private PathToFileResolver fileResolver;
    private String contentCharset;

    public DefaultManifest(PathToFileResolver fileResolver) {
        this(fileResolver, DEFAULT_CONTENT_CHARSET);
    }

    public DefaultManifest(PathToFileResolver fileResolver, String contentCharset) {
        this.fileResolver = fileResolver;
        this.contentCharset = contentCharset;
        this.init();
    }

    public DefaultManifest(Object manifestPath, PathToFileResolver fileResolver) {
        this(manifestPath, fileResolver, DEFAULT_CONTENT_CHARSET);
    }

    public DefaultManifest(Object manifestPath, PathToFileResolver fileResolver, String contentCharset) {
        this.fileResolver = fileResolver;
        this.contentCharset = contentCharset;
        this.read(manifestPath);
    }

    private void init() {
        this.getAttributes().put("Manifest-Version", "1.0");
    }

    @Override
    public String getContentCharset() {
        return this.contentCharset;
    }

    @Override
    public void setContentCharset(String contentCharset) {
        if (contentCharset == null) {
            throw new InvalidUserDataException("contentCharset must not be null");
        }
        if (!Charset.isSupported(contentCharset)) {
            throw new InvalidUserDataException(String.format("Charset for contentCharset '%s' is not supported by your JVM", contentCharset));
        }
        this.contentCharset = contentCharset;
    }

    public DefaultManifest mainAttributes(Map<String, ?> attributes) {
        return this.attributes((Map)attributes);
    }

    @Override
    public DefaultManifest attributes(Map<String, ?> attributes) {
        this.getAttributes().putAll(attributes);
        return this;
    }

    @Override
    public DefaultManifest attributes(Map<String, ?> attributes, String sectionName) {
        if (!this.sections.containsKey(sectionName)) {
            this.sections.put(sectionName, new DefaultAttributes());
        }
        this.sections.get(sectionName).putAll(attributes);
        return this;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, Attributes> getSections() {
        return this.sections;
    }

    public DefaultManifest clear() {
        this.attributes.clear();
        this.sections.clear();
        this.manifestMergeSpecs.clear();
        this.init();
        return this;
    }

    static java.util.jar.Manifest generateJavaManifest(Manifest gradleManifest) {
        java.util.jar.Manifest javaManifest = new java.util.jar.Manifest();
        DefaultManifest.addMainAttributesToJavaManifest(gradleManifest, javaManifest);
        DefaultManifest.addSectionAttributesToJavaManifest(gradleManifest, javaManifest);
        return javaManifest;
    }

    private static void addMainAttributesToJavaManifest(Manifest gradleManifest, java.util.jar.Manifest javaManifest) {
        DefaultManifest.fillAttributes(gradleManifest.getAttributes(), javaManifest.getMainAttributes());
    }

    private static void addSectionAttributesToJavaManifest(Manifest gradleManifest, java.util.jar.Manifest javaManifest) {
        for (Map.Entry<String, Attributes> entry : gradleManifest.getSections().entrySet()) {
            String sectionName = entry.getKey();
            java.util.jar.Attributes targetAttributes = new java.util.jar.Attributes();
            DefaultManifest.fillAttributes(entry.getValue(), targetAttributes);
            javaManifest.getEntries().put(sectionName, targetAttributes);
        }
    }

    private static void fillAttributes(Attributes attributes, java.util.jar.Attributes targetAttributes) {
        for (Map.Entry entry : attributes.entrySet()) {
            String mainAttributeName = (String)entry.getKey();
            String mainAttributeValue = DefaultManifest.resolveValueToString(entry.getValue());
            if (mainAttributeValue == null) continue;
            targetAttributes.putValue(mainAttributeName, mainAttributeValue);
        }
    }

    private static String resolveValueToString(Object value) {
        Object underlyingValue = value;
        if (value instanceof Provider) {
            Provider provider = (Provider)Cast.uncheckedCast(value);
            if (!provider.isPresent()) {
                return null;
            }
            underlyingValue = provider.get();
        }
        return underlyingValue.toString();
    }

    @Override
    public DefaultManifest from(Object ... mergePaths) {
        return this.from((Object)mergePaths, Actions.doNothing());
    }

    @Override
    public DefaultManifest from(Object mergePaths, Closure<?> closure) {
        return this.from(mergePaths, (Action)ClosureBackedAction.of(closure));
    }

    @Override
    public DefaultManifest from(Object mergePath, Action<ManifestMergeSpec> action) {
        DefaultManifestMergeSpec mergeSpec = new DefaultManifestMergeSpec();
        mergeSpec.from(mergePath);
        this.manifestMergeSpecs.add(mergeSpec);
        action.execute(mergeSpec);
        return this;
    }

    @Override
    public DefaultManifest getEffectiveManifest() {
        return this.getEffectiveManifestInternal(this);
    }

    protected DefaultManifest getEffectiveManifestInternal(DefaultManifest baseManifest) {
        DefaultManifest resultManifest = baseManifest;
        for (ManifestMergeSpec manifestMergeSpec : this.manifestMergeSpecs) {
            resultManifest = ((DefaultManifestMergeSpec)manifestMergeSpec).merge(resultManifest, this.fileResolver);
        }
        return resultManifest;
    }

    @Override
    public Manifest writeTo(OutputStream outputStream) {
        DefaultManifest.writeTo(this, outputStream, this.contentCharset);
        return this;
    }

    static void writeTo(Manifest manifest, OutputStream outputStream, String contentCharset) {
        try {
            java.util.jar.Manifest javaManifest = DefaultManifest.generateJavaManifest(manifest.getEffectiveManifest());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            javaManifest.write(buffer);
            byte[] manifestBytes = DEFAULT_CONTENT_CHARSET.equals(contentCharset) ? buffer.toByteArray() : buffer.toString(DEFAULT_CONTENT_CHARSET).getBytes(contentCharset);
            outputStream.write(manifestBytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Manifest writeTo(Object path) {
        File manifestFile = this.fileResolver.resolve(path);
        try {
            File parentFile = manifestFile.getParentFile();
            if (parentFile != null) {
                FileUtils.forceMkdir((File)parentFile);
            }
            IoActions.withResource(new FileOutputStream(manifestFile), new Action<FileOutputStream>(){

                @Override
                public void execute(FileOutputStream fileOutputStream) {
                    DefaultManifest.this.writeTo(fileOutputStream);
                }
            });
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<ManifestMergeSpec> getMergeSpecs() {
        return this.manifestMergeSpecs;
    }

    public boolean isEqualsTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DefaultManifest)) {
            return false;
        }
        DefaultManifest effectiveThis = this.getEffectiveManifest();
        DefaultManifest effectiveThat = ((DefaultManifest)o).getEffectiveManifest();
        if (!effectiveThis.attributes.equals(effectiveThat.attributes)) {
            return false;
        }
        return effectiveThis.sections.equals(effectiveThat.sections);
    }

    private void read(Object manifestPath) {
        File manifestFile = this.fileResolver.resolve(manifestPath);
        try {
            byte[] manifestBytes = FileUtils.readFileToByteArray((File)manifestFile);
            manifestBytes = this.prepareManifestBytesForInteroperability(manifestBytes);
            if (!DEFAULT_CONTENT_CHARSET.equals(this.contentCharset)) {
                manifestBytes = new String(manifestBytes, this.contentCharset).getBytes(DEFAULT_CONTENT_CHARSET);
            }
            java.util.jar.Manifest javaManifest = new java.util.jar.Manifest(new ByteArrayInputStream(manifestBytes));
            this.addJavaManifestToAttributes(javaManifest);
            this.addJavaManifestToSections(javaManifest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private byte[] prepareManifestBytesForInteroperability(byte[] original) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        boolean useCarriageReturns = false;
        byte carriageReturn = 13;
        byte newLine = 10;
        for (int idx = 0; idx < original.length; ++idx) {
            byte current = original[idx];
            if (current == carriageReturn) {
                useCarriageReturns = true;
            }
            if (idx == original.length - 1) {
                output.write(current);
                if (useCarriageReturns) {
                    output.write(carriageReturn);
                }
                output.write(newLine);
                continue;
            }
            if (current == newLine && idx + 5 < original.length) {
                output.write(current);
                if (original[idx + 1] != 78 && original[idx + 1] != 110 || original[idx + 2] != 65 && original[idx + 2] != 97 || original[idx + 3] != 77 && original[idx + 3] != 109 || original[idx + 4] != 69 && original[idx + 4] != 101 || original[idx + 5] != 58) continue;
                if (useCarriageReturns) {
                    output.write(carriageReturn);
                }
                output.write(newLine);
                continue;
            }
            output.write(current);
        }
        return output.toByteArray();
    }

    private void addJavaManifestToAttributes(java.util.jar.Manifest javaManifest) {
        this.attributes.put("Manifest-Version", (Object)"1.0");
        for (Object attributeKey : javaManifest.getMainAttributes().keySet()) {
            String attributeName = attributeKey.toString();
            String attributeValue = javaManifest.getMainAttributes().getValue(attributeName);
            this.attributes.put(attributeName, (Object)attributeValue);
        }
    }

    private void addJavaManifestToSections(java.util.jar.Manifest javaManifest) {
        for (Map.Entry<String, java.util.jar.Attributes> sectionEntry : javaManifest.getEntries().entrySet()) {
            String sectionName = sectionEntry.getKey();
            DefaultAttributes sectionAttributes = new DefaultAttributes();
            for (Object attributeKey : sectionEntry.getValue().keySet()) {
                String attributeName = attributeKey.toString();
                String attributeValue = sectionEntry.getValue().getValue(attributeName);
                sectionAttributes.put(attributeName, (Object)attributeValue);
            }
            this.sections.put(sectionName, sectionAttributes);
        }
    }
}

