/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

class AggregatingProcessingStrategy
extends IncrementalProcessingStrategy {
    private static final Map<Class<?>, Optional<Field>> FIELD_CACHE = new HashMap(5);
    private static Boolean canAccessJDKTypes;

    AggregatingProcessingStrategy(AnnotationProcessorResult result) {
        super(result);
        result.setType(IncrementalAnnotationProcessorType.AGGREGATING);
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.validateAnnotations(annotations);
        this.recordAggregatedTypes(supportedAnnotationTypes, annotations, roundEnv);
    }

    private void validateAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            Retention retention = typeElement.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.SOURCE) continue;
            this.result.setFullRebuildCause("'@" + typeElement.getSimpleName() + "' has source retention. Aggregating annotation processors require class or runtime retention");
        }
    }

    private void recordAggregatedTypes(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (supportedAnnotationTypes.contains("*")) {
            this.result.getAggregatedTypes().addAll(AggregatingProcessingStrategy.namesOfElementsWithSource(roundEnv.getRootElements()));
        } else {
            for (TypeElement typeElement : annotations) {
                this.result.getAggregatedTypes().addAll(AggregatingProcessingStrategy.namesOfElementsWithSource(roundEnv.getElementsAnnotatedWith(typeElement)));
            }
        }
    }

    private static Set<String> namesOfElementsWithSource(Set<? extends Element> orig) {
        if (orig == null || orig.isEmpty()) {
            return Collections.emptySet();
        }
        return orig.stream().map(ElementUtils::getTopLevelType).filter(AggregatingProcessingStrategy::filterElements).map(ElementUtils::getElementName).collect(Collectors.toSet());
    }

    private static boolean filterElements(Element element) {
        if (AggregatingProcessingStrategy.canAccessJDKTypes()) {
            return AggregatingProcessingStrategy.filterElementsDirect(element);
        }
        return AggregatingProcessingStrategy.filterElementsReflection(element);
    }

    private static boolean filterElementsReflection(Element element) {
        try {
            Optional field = FIELD_CACHE.computeIfAbsent(element.getClass(), AggregatingProcessingStrategy::getField);
            if (field.isPresent()) {
                return ((Field)field.get()).get(element) != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            FIELD_CACHE.put(element.getClass(), Optional.empty());
            return false;
        }
    }

    private static Optional<Field> getField(Class<?> clazz) {
        try {
            Field sourceFile = clazz.getField("sourceFile");
            return Optional.of(sourceFile);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private static boolean filterElementsDirect(Element element) {
        if (element instanceof Symbol.ClassSymbol) {
            return ((Symbol.ClassSymbol)element).sourcefile != null;
        }
        return false;
    }

    private static boolean canAccessJDKTypes() {
        if (canAccessJDKTypes == null) {
            try {
                AggregatingProcessingStrategy.class.getClassLoader().loadClass("com.sun.tools.javac.code.Symbol");
                canAccessJDKTypes = Boolean.TRUE;
            }
            catch (Throwable t) {
                canAccessJDKTypes = Boolean.FALSE;
            }
        }
        return canAccessJDKTypes;
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        this.result.getGeneratedAggregatingTypes().add(name.toString());
    }

    @Override
    public void recordGeneratedResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element[] originatingElements) {
        GeneratedResource.Location resourceLocation = GeneratedResource.Location.from(location);
        if (resourceLocation == null) {
            this.result.setFullRebuildCause(location + " is not supported for incremental annotation processing");
        } else {
            this.result.getGeneratedAggregatingResources().add(new GeneratedResource(resourceLocation, pkg, relativeName));
        }
    }
}

