/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.util.ConfigureUtil;

public class DefaultGroovySourceSet
implements GroovySourceSet,
HasPublicType {
    private final SourceDirectorySet groovy;
    private final SourceDirectorySet allGroovy;

    public DefaultGroovySourceSet(String name, String displayName, ObjectFactory objectFactory) {
        this.groovy = objectFactory.sourceDirectorySet(name, displayName + " Groovy source");
        this.groovy.getFilter().include("**/*.java", "**/*.groovy");
        this.allGroovy = objectFactory.sourceDirectorySet("all" + name, displayName + " Groovy source");
        this.allGroovy.source(this.groovy);
        this.allGroovy.getFilter().include("**/*.groovy");
    }

    @Override
    public SourceDirectorySet getGroovy() {
        return this.groovy;
    }

    @Override
    public GroovySourceSet groovy(@Nullable Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getGroovy());
        return this;
    }

    @Override
    public GroovySourceSet groovy(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute(this.getGroovy());
        return this;
    }

    @Override
    public SourceDirectorySet getAllGroovy() {
        return this.allGroovy;
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GroovySourceSet.class);
    }
}

