/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.UnionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictResolutionDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;

public class SelectorStateResolver<T extends ComponentResolutionState> {
    private final ModuleConflictResolver<T> conflictResolver;
    private final ComponentStateFactory<T> componentFactory;
    private final T rootComponent;
    private final ModuleIdentifier rootModuleId;
    private final ResolveOptimizations resolveOptimizations;
    private final Comparator<Version> versionComparator;

    public SelectorStateResolver(ModuleConflictResolver<T> conflictResolver, ComponentStateFactory<T> componentFactory, T rootComponent, ResolveOptimizations resolveOptimizations, Comparator<Version> versionComparator) {
        this.conflictResolver = conflictResolver;
        this.componentFactory = componentFactory;
        this.rootComponent = rootComponent;
        this.rootModuleId = rootComponent.getId().getModule();
        this.resolveOptimizations = resolveOptimizations;
        this.versionComparator = versionComparator;
    }

    public T selectBest(ModuleIdentifier moduleId, ModuleSelectors<? extends ResolvableSelectorState> selectors) {
        List allowed;
        VersionSelector allRejects = this.createAllRejects(selectors);
        List<T> candidates = this.resolveSelectors(selectors, allRejects);
        assert (!candidates.isEmpty());
        if (moduleId.equals(this.rootModuleId) && !candidates.contains(this.rootComponent)) {
            candidates = new ArrayList<T>(candidates);
            candidates.add(this.rootComponent);
        }
        if (candidates.size() == 1) {
            return (T)((ComponentResolutionState)candidates.get(0));
        }
        if (this.resolveOptimizations.mayHaveForcedPlatforms() && !(allowed = candidates.stream().filter(SelectorStateResolverResults::isVersionAllowedByPlatform).collect(Collectors.toList())).isEmpty()) {
            if (allowed.size() == 1) {
                return (T)((ComponentResolutionState)allowed.get(0));
            }
            candidates = allowed;
        }
        return this.resolveConflicts(candidates);
    }

    private List<T> resolveSelectors(ModuleSelectors<? extends ResolvableSelectorState> selectors, VersionSelector allRejects) {
        ResolvableSelectorState selectorState;
        if (selectors.size() == 1 && ((selectorState = selectors.first()).getVersionConstraint() == null || selectorState.getVersionConstraint().getPreferredSelector() == null)) {
            return this.resolveSingleSelector(selectorState, allRejects);
        }
        List<T> results = this.buildResolveResults(selectors, allRejects);
        if (results.isEmpty()) {
            return this.resolveSingleSelector(selectors.first(), allRejects);
        }
        return results;
    }

    private List<T> resolveSingleSelector(ResolvableSelectorState selectorState, VersionSelector allRejects) {
        assert (selectorState.getVersionConstraint() == null || selectorState.getVersionConstraint().getPreferredSelector() == null);
        ComponentIdResolveResult resolved = selectorState.resolve(allRejects);
        T selected = SelectorStateResolverResults.componentForIdResolveResult(this.componentFactory, resolved, selectorState);
        return Collections.singletonList(selected);
    }

    private List<T> buildResolveResults(ModuleSelectors<? extends ResolvableSelectorState> selectors, VersionSelector allRejects) {
        SelectorStateResolverResults results = new SelectorStateResolverResults(this.versionComparator, selectors.size());
        TreeSet<ComponentIdResolveResult> preferResults = null;
        for (ResolvableSelectorState resolvableSelectorState : selectors) {
            this.resolveRequireConstraint(results, resolvableSelectorState, allRejects);
            preferResults = this.maybeResolvePreferConstraint(preferResults, resolvableSelectorState, allRejects);
        }
        this.integratePreferResults(selectors, results, preferResults);
        return results.getResolved(this.componentFactory);
    }

    private void resolveRequireConstraint(SelectorStateResolverResults results, ResolvableSelectorState selector, VersionSelector allRejects) {
        if (results.alreadyHaveResolutionForSelector(selector)) {
            return;
        }
        ComponentIdResolveResult result = selector.resolve(allRejects);
        if (result.getFailure() != null) {
            results.register(selector, result);
            return;
        }
        results.replaceExistingResolutionsWithBetterResult(result, selector.isFromLock());
        results.register(selector, result);
    }

    private TreeSet<ComponentIdResolveResult> maybeResolvePreferConstraint(TreeSet<ComponentIdResolveResult> previousResults, ResolvableSelectorState selector, VersionSelector allRejects) {
        TreeSet preferResults = previousResults;
        ComponentIdResolveResult resolvedPreference = selector.resolvePrefer(allRejects);
        if (resolvedPreference != null && resolvedPreference.getFailure() == null) {
            if (preferResults == null) {
                preferResults = Sets.newTreeSet((Comparator)new DescendingResolveResultComparator());
            }
            preferResults.add((ComponentIdResolveResult)resolvedPreference);
        }
        return preferResults;
    }

    private void integratePreferResults(ModuleSelectors<? extends ResolvableSelectorState> selectors, SelectorStateResolverResults results, TreeSet<ComponentIdResolveResult> preferResults) {
        if (preferResults == null) {
            return;
        }
        if (results.isEmpty()) {
            ComponentIdResolveResult highestPreferredVersion = preferResults.first();
            results.register(selectors.first(), highestPreferredVersion);
            return;
        }
        for (ComponentIdResolveResult preferResult : preferResults) {
            if (results.replaceExistingResolutionsWithBetterResult(preferResult, false)) break;
        }
    }

    private VersionSelector createAllRejects(ModuleSelectors<? extends ResolvableSelectorState> selectors) {
        List rejectSelectors = null;
        for (ResolvableSelectorState resolvableSelectorState : selectors) {
            ResolvedVersionConstraint versionConstraint = resolvableSelectorState.getVersionConstraint();
            if (versionConstraint == null || versionConstraint.getRejectedSelector() == null) continue;
            if (rejectSelectors == null) {
                rejectSelectors = Lists.newArrayListWithCapacity((int)selectors.size());
            }
            rejectSelectors.add(versionConstraint.getRejectedSelector());
        }
        if (rejectSelectors == null) {
            return null;
        }
        if (rejectSelectors.size() == 1) {
            return (VersionSelector)rejectSelectors.get(0);
        }
        return new UnionVersionSelector(rejectSelectors);
    }

    private T resolveConflicts(Collection<T> candidates) {
        DefaultConflictResolverDetails<T> details = new DefaultConflictResolverDetails<T>(candidates);
        this.conflictResolver.select(details);
        ComponentResolutionState selected = (ComponentResolutionState)details.getSelected();
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException(details.getFailure());
        }
        ComponentSelectionDescriptorInternal desc = ComponentSelectionReasons.CONFLICT_RESOLUTION;
        selected.addCause(desc.withDescription(new VersionConflictResolutionDetails(candidates)));
        return (T)selected;
    }

    private static class DescendingResolveResultComparator
    implements Comparator<ComponentIdResolveResult> {
        private DescendingResolveResultComparator() {
        }

        @Override
        public int compare(ComponentIdResolveResult o1, ComponentIdResolveResult o2) {
            return o2.getModuleVersionId().getVersion().compareTo(o1.getModuleVersionId().getVersion());
        }
    }
}

