/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report;

import java.nio.file.Path;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.AbstractTextDependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationHighLevelErrors;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.logging.text.TreeFormatter;

class TextDependencyVerificationReportRenderer
extends AbstractTextDependencyVerificationReportRenderer {
    private boolean inMultiErrors;

    public TextDependencyVerificationReportRenderer(Path gradleUserHome, DocumentationRegistry documentationRegistry) {
        super(gradleUserHome, documentationRegistry);
    }

    @Override
    public void startNewSection(String title) {
        this.formatter = new TreeFormatter();
        this.formatter.node("Dependency verification failed for " + title);
    }

    @Override
    public void startArtifactErrors(Runnable action) {
        this.formatter.startChildren();
        action.run();
        this.formatter.endChildren();
        this.formatter.blankLine();
    }

    @Override
    public void startNewArtifact(ModuleComponentArtifactIdentifier key, Runnable action) {
        this.formatter.node("On artifact " + key + " ");
        action.run();
    }

    @Override
    public void reportFailure(RepositoryAwareVerificationFailure failure) {
        if (this.inMultiErrors) {
            this.formatter.node("");
        }
        this.formatter.append("in repository '" + failure.getRepositoryName() + "': ");
        failure.getFailure().explainTo(this.formatter);
    }

    @Override
    public void reportAsMultipleErrors(Runnable action) {
        this.formatter.append("multiple problems reported:");
        this.formatter.startChildren();
        this.inMultiErrors = true;
        action.run();
        this.inMultiErrors = false;
        this.formatter.endChildren();
    }

    private void processAffectedFiles(Set<String> affectedFiles) {
        this.formatter.blankLine();
        this.formatter.node("These files failed verification:");
        this.formatter.startChildren();
        for (String affectedFile : affectedFiles) {
            this.formatter.node(affectedFile);
        }
        this.formatter.endChildren();
        this.formatter.blankLine();
        this.formatter.node("GRADLE_USER_HOME = " + this.gradleUserHome);
    }

    @Override
    public void finish(VerificationHighLevelErrors highLevelErrors) {
        super.finish(highLevelErrors);
        Set<String> affectedFiles = highLevelErrors.getAffectedFiles();
        if (!affectedFiles.isEmpty()) {
            this.processAffectedFiles(affectedFiles);
        }
        this.formatter.blankLine();
        this.formatter.node("These files failed verification:");
        this.formatter.startChildren();
        for (String affectedFile : highLevelErrors.getAffectedFiles()) {
            this.formatter.node(affectedFile);
        }
        this.formatter.endChildren();
        this.formatter.blankLine();
        this.formatter.node("GRADLE_USER_HOME = " + this.gradleUserHome);
    }
}

