/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.ExecuteDomainObjectCollectionCallbackBuildOperationType;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configuration.internal.UserCodeApplicationId;
import org.gradle.internal.InternalListener;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class DefaultCollectionCallbackActionDecorator
implements CollectionCallbackActionDecorator {
    private final BuildOperationExecutor buildOperationExecutor;
    private final UserCodeApplicationContext userCodeApplicationContext;

    public DefaultCollectionCallbackActionDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    @Override
    public <T> Action<T> decorate(@Nullable Action<T> action) {
        if (action == null || action instanceof InternalListener) {
            return action;
        }
        UserCodeApplicationContext.Application application = this.userCodeApplicationContext.current();
        if (application == null) {
            return action;
        }
        return new BuildOperationEmittingAction<T>(application.getId(), application.reapplyLater(action));
    }

    private class BuildOperationEmittingAction<T>
    implements Action<T> {
        private final UserCodeApplicationId applicationId;
        private final Action<T> delegate;

        BuildOperationEmittingAction(UserCodeApplicationId applicationId, Action<T> delegate) {
            this.applicationId = applicationId;
            this.delegate = delegate;
        }

        @Override
        public void execute(final T arg) {
            DefaultCollectionCallbackActionDecorator.this.buildOperationExecutor.run(new Operation(this.applicationId){

                @Override
                public void run(BuildOperationContext context) {
                    BuildOperationEmittingAction.this.delegate.execute(arg);
                    context.setResult(ExecuteDomainObjectCollectionCallbackBuildOperationType.RESULT);
                }
            });
        }
    }

    private static class OperationDetails
    implements ExecuteDomainObjectCollectionCallbackBuildOperationType.Details {
        private final UserCodeApplicationId applicationId;

        OperationDetails(UserCodeApplicationId applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public long getApplicationId() {
            return this.applicationId.longValue();
        }
    }

    private static abstract class Operation
    implements RunnableBuildOperation {
        private final UserCodeApplicationId applicationId;

        Operation(UserCodeApplicationId applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Execute container callback action").details(new OperationDetails(this.applicationId));
        }
    }
}

