/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.openapi.util.Getter;
import com.intellij.util.ThrowableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingModel;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingConfigImpl;
import org.jetbrains.plugins.gradle.tooling.internal.AnnotationProcessingModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class AnnotationProcessingModelSerializationService
implements SerializationService<AnnotationProcessingModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(AnnotationProcessingModel annotationProcessingModel, Class<? extends AnnotationProcessingModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            AnnotationProcessingModelSerializationService.write(writer, this.myWriteContext, annotationProcessingModel);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationProcessingModel read(byte[] object, Class<? extends AnnotationProcessingModel> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            AnnotationProcessingModel annotationProcessingModel = AnnotationProcessingModelSerializationService.read(reader, this.myReadContext);
            return annotationProcessingModel;
        }
        finally {
            reader.close();
        }
    }

    private static void write(final IonWriter writer, final WriteContext context, final AnnotationProcessingModel model) throws IOException {
        context.objectCollector.add((Object)model, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    AnnotationProcessingModelSerializationService.writeConfigs(writer, context, model.allConfigs());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeConfigs(final IonWriter writer, final WriteContext context, Map<String, AnnotationProcessingConfig> configs) throws IOException {
        ToolingStreamApiUtils.writeMap((IonWriter)writer, (String)"configs", configs, (ThrowableConsumer)new ThrowableConsumer<String, IOException>(){

            public void consume(String s) throws IOException {
                writer.writeString(s);
            }
        }, (ThrowableConsumer)new ThrowableConsumer<AnnotationProcessingConfig, IOException>(){

            public void consume(AnnotationProcessingConfig config) throws IOException {
                AnnotationProcessingModelSerializationService.writeConfig(writer, context, config);
            }
        });
    }

    private static void writeConfig(final IonWriter writer, WriteContext context, final AnnotationProcessingConfig config) throws IOException {
        context.configCollector.add((Object)config, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeStrings((IonWriter)writer, (String)"args", (Collection)config.getAnnotationProcessorArguments());
                    ToolingStreamApiUtils.writeStrings((IonWriter)writer, (String)"paths", (Collection)config.getAnnotationProcessorPath());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"output", (String)config.getProcessorOutput());
                    ToolingStreamApiUtils.writeBoolean((IonWriter)writer, (String)"isTestSources", (boolean)config.isTestSources());
                }
                writer.stepOut();
            }
        });
    }

    private static AnnotationProcessingModel read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        AnnotationProcessingModelImpl model = (AnnotationProcessingModelImpl)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<AnnotationProcessingModelImpl>(){

            public AnnotationProcessingModelImpl create() {
                Map configs = AnnotationProcessingModelSerializationService.readConfigs(reader, context);
                return new AnnotationProcessingModelImpl(configs);
            }
        });
        reader.stepOut();
        return model;
    }

    private static Map<String, AnnotationProcessingConfig> readConfigs(final IonReader reader, final ReadContext context) {
        return ToolingStreamApiUtils.readMap((IonReader)reader, (Getter)new Getter<String>(){

            public String get() {
                return ToolingStreamApiUtils.readString((IonReader)reader, null);
            }
        }, (Getter)new Getter<AnnotationProcessingConfig>(){

            public AnnotationProcessingConfig get() {
                return AnnotationProcessingModelSerializationService.readConfig(reader, context);
            }
        });
    }

    private static AnnotationProcessingConfig readConfig(final IonReader reader, ReadContext context) {
        reader.next();
        reader.stepIn();
        AnnotationProcessingConfigImpl config = (AnnotationProcessingConfigImpl)context.configMap.computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<AnnotationProcessingConfigImpl>(){

            public AnnotationProcessingConfigImpl create() {
                List args = ToolingStreamApiUtils.readStringList((IonReader)reader);
                List files = ToolingStreamApiUtils.readStringList((IonReader)reader);
                String output = ToolingStreamApiUtils.readString((IonReader)reader, (String)"output");
                boolean isTest = ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"isTestSources");
                return new AnnotationProcessingConfigImpl(files, args, output, isTest);
            }
        });
        reader.stepOut();
        return config;
    }

    public Class<? extends AnnotationProcessingModel> getModelClass() {
        return AnnotationProcessingModel.class;
    }

    private static class ReadContext {
        private final IntObjectMap<AnnotationProcessingModelImpl> objectMap = new IntObjectMap();
        private final IntObjectMap<AnnotationProcessingConfigImpl> configMap = new IntObjectMap();

        private ReadContext() {
        }
    }

    private static class WriteContext {
        private final ObjectCollector<AnnotationProcessingModel, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<AnnotationProcessingConfig, IOException> configCollector = new ObjectCollector();

        private WriteContext() {
        }
    }
}

