/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspectionBase;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;

public class InspectionDescriptionNotFoundInspection
extends DescriptionNotFoundInspectionBase {
    @NonNls
    private static final String INSPECTION_PROFILE_ENTRY = DescriptionType.INSPECTION.getClassName();

    public InspectionDescriptionNotFoundInspection() {
        super(DescriptionType.INSPECTION);
    }

    @Override
    protected boolean skipIfNotRegistered(PsiClass epClass) {
        return InspectionDescriptionNotFoundInspection.isAnyPathMethodOverridden(epClass);
    }

    @Override
    protected boolean checkDynamicDescription(ProblemsHolder holder, Module module, PsiClass psiClass) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        return info.isValid() && info.hasDescriptionFile();
    }

    @Override
    @Nullable
    protected String getDescriptionDir(Module module, PsiClass psiClass) {
        return InspectionDescriptionInfo.create(module, psiClass).getFilename();
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getHasNotDescriptionError(Module module, PsiClass psiClass) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        PsiMethod shortNameMethod = info.getShortNameMethod();
        String methodName = shortNameMethod == null ? "" : " [" + shortNameMethod.getName() + "()]";
        String string = DevKitBundle.message("inspections.inspection.description.optional.short.name", methodName);
        if (string == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getHasNotBeforeAfterError() {
        return "";
    }

    private static boolean isAnyPathMethodOverridden(PsiClass psiClass) {
        return !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", psiClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @Nullable PsiClass psiClass) {
        if (methodName == null) {
            InspectionDescriptionNotFoundInspection.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            return false;
        }
        int n = 0;
        PsiMethod[] psiMethodArray = psiClass.findMethodsByName(methodName, false);
        int n2 = psiMethodArray.length;
        if (n < n2) {
            PsiMethod method = psiMethodArray[n];
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return INSPECTION_PROFILE_ENTRY.equals(containingClass.getQualifiedName());
        }
        return InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, psiClass.getSuperClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHasNotDescriptionError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/InspectionDescriptionNotFoundInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLastMethodDefinitionIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

