/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.lang.Commenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J*\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\"\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u0006H\u0016J%\u0010&\u001a\u00070\u001d\u00a2\u0006\u0002\b'2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002J,\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J,\u0010-\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/intellij/plugins/markdown/lang/MarkdownCommenter;", "Lcom/intellij/lang/Commenter;", "Lcom/intellij/codeInsight/generation/SelfManagingCommenter;", "Lcom/intellij/codeInsight/generation/CommenterDataHolder;", "()V", "closeRoundBracket", "", "commentPrefix", "escapedCloseBracket", "escapedOpenBracket", "openRoundBracket", "commentLine", "", "line", "", "offset", "document", "Lcom/intellij/openapi/editor/Document;", "data", "createBlockCommentingState", "selectionStart", "selectionEnd", "file", "Lcom/intellij/psi/PsiFile;", "createLineCommentingState", "startLine", "endLine", "escape", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "getBlockCommentPrefix", "getBlockCommentRange", "Lcom/intellij/openapi/util/TextRange;", "getBlockCommentSuffix", "getCommentPrefix", "getCommentedBlockCommentPrefix", "getCommentedBlockCommentSuffix", "getLineCommentPrefix", "getRangeMarker", "Lorg/jetbrains/annotations/NotNull;", "startOffset", "endOffset", "insertBlockComment", "isLineCommented", "", "uncommentBlockComment", "uncommentLine", "unescape", "intellij.markdown"})
public final class MarkdownCommenter
implements Commenter,
SelfManagingCommenter<CommenterDataHolder> {
    private final String commentPrefix;
    private final String openRoundBracket;
    private final String closeRoundBracket;
    private final String escapedOpenBracket;
    private final String escapedCloseBracket;

    @Nullable
    public String getLineCommentPrefix() {
        return this.commentPrefix;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return this.commentPrefix;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return this.closeRoundBracket;
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.commentPrefix;
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)this.commentPrefix);
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, @Nullable Document document, @Nullable CommenterDataHolder data) {
        return new TextRange(0, 0);
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        String prefix;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int endOffset = document.getLineEndOffset(line);
        RangeMarker marker = this.getRangeMarker(document, offset, endOffset);
        String string = line == 0 ? this.commentPrefix : (prefix = DocumentUtil.isLineEmpty((Document)document, (int)(line - 1)) ? this.commentPrefix : '\n' + this.commentPrefix);
        if (!DocumentUtil.isLineEmpty((Document)document, (int)line)) {
            this.escape(document, marker);
            document.insertString(marker.getEndOffset(), (CharSequence)this.closeRoundBracket);
            document.insertString(marker.getStartOffset(), (CharSequence)prefix);
        }
        marker.dispose();
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int endOffset = document.getLineEndOffset(line);
        RangeMarker marker = this.getRangeMarker(document, offset, endOffset);
        int startOffset = line == 0 ? offset : (document.isLineModified(line - 1) ? document.getLineStartOffset(line - 1) : offset);
        document.deleteString(endOffset - this.closeRoundBracket.length(), endOffset);
        document.deleteString(startOffset, offset + this.commentPrefix.length());
        this.unescape(document, marker);
        marker.dispose();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, @Nullable Document document, @Nullable CommenterDataHolder data) {
    }

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    private final RangeMarker getRangeMarker(Document document, int startOffset, int endOffset) {
        RangeMarker rangeMarker = document.createRangeMarker(startOffset, endOffset);
        boolean bl = false;
        boolean bl2 = false;
        RangeMarker $this$apply = rangeMarker;
        boolean bl3 = false;
        RangeMarker rangeMarker2 = $this$apply;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"this");
        rangeMarker2.setGreedyToLeft(true);
        $this$apply.setGreedyToRight(true);
        RangeMarker rangeMarker3 = rangeMarker;
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker3, (String)"document\n    .createRang\u2026reedyToRight = true\n    }");
        return rangeMarker3;
    }

    /*
     * WARNING - void declaration
     */
    private final void escape(Document document, RangeMarker range) {
        int end;
        int start = range.getStartOffset();
        if (start >= (end = range.getEndOffset())) {
            return;
        }
        int n = end;
        int n2 = start;
        if (n >= n2) {
            while (true) {
                void i;
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i, (CharSequence)this.closeRoundBracket)) {
                    document.replaceString((int)i, (int)(i + this.closeRoundBracket.length()), (CharSequence)this.escapedCloseBracket);
                }
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i, (CharSequence)this.openRoundBracket)) {
                    document.replaceString((int)i, (int)(i + this.openRoundBracket.length()), (CharSequence)this.escapedOpenBracket);
                }
                if (i == n2) break;
                --i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void unescape(Document document, RangeMarker range) {
        int n;
        int n2 = range.getEndOffset();
        if (n2 >= (n = range.getStartOffset())) {
            while (true) {
                void i;
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i, (CharSequence)this.escapedCloseBracket)) {
                    document.replaceString((int)i, (int)(i + this.escapedCloseBracket.length()), (CharSequence)this.closeRoundBracket);
                }
                if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)i, (CharSequence)this.escapedOpenBracket)) {
                    document.replaceString((int)i, (int)(i + this.escapedOpenBracket.length()), (CharSequence)this.openRoundBracket);
                }
                if (i == n) break;
                --i;
            }
        }
    }

    public MarkdownCommenter() {
        this.commentPrefix = "[comment]: <> (";
        this.openRoundBracket = "(";
        this.closeRoundBracket = ")";
        this.escapedOpenBracket = "&#40;";
        this.escapedCloseBracket = "&#41;";
    }
}

